/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.datastruct.LRUSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamespaceCache {
    public static final int MAX_RECENTS = 10;
    private static Map<Program, LRUSet<Namespace>> recentNamespaces = new HashMap<Program, LRUSet<Namespace>>();

    public static List<Namespace> get(Program program) {
        LRUSet<Namespace> recents = recentNamespaces.get(program);
        return recents != null ? recents.toList() : Collections.emptyList();
    }

    public static void add(Program program, Namespace namespace) {
        if (namespace.isGlobal()) {
            return;
        }
        LRUSet recents = recentNamespaces.get(program);
        if (recents == null) {
            recents = new LRUSet(10);
            recentNamespaces.put(program, (LRUSet<Namespace>)recents);
            program.addCloseListener(p -> recentNamespaces.remove(p));
        }
        recents.add((Object)namespace);
    }
}

