/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFAbbreviation;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFTag;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFFormContext;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DebugInfoEntry {
    private final DWARFCompilationUnit compilationUnit;
    private final DWARFAbbreviation abbreviation;
    private final DWARFAttributeValue[] attributes;
    private final int[] attrOffsets;
    private final long offset;
    private final int dieIndex;

    public static DebugInfoEntry read(BinaryReader reader, DWARFCompilationUnit cu, int dieIndex) throws IOException {
        long offset = reader.getPointerIndex();
        int ac = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        if (ac == 0) {
            return new DebugInfoEntry(cu, offset);
        }
        DWARFAbbreviation abbreviation = cu.getAbbreviation(ac);
        if (abbreviation == null) {
            throw new IOException("Abbreviation code %d not found in compunit %d at 0x%x".formatted(ac, cu.getUnitNumber(), cu.getStartOffset()));
        }
        int[] attrOffsets = new int[abbreviation.getAttributeCount()];
        DWARFAttribute.AttrDef[] attributeSpecs = abbreviation.getAttributes();
        int currentAttrOffset = (int)(reader.getPointerIndex() - offset);
        for (int i = 0; i < attributeSpecs.length; ++i) {
            attrOffsets[i] = currentAttrOffset;
            DWARFAttribute.AttrDef attributeSpec = attributeSpecs[i];
            DWARFFormContext context = new DWARFFormContext(reader, cu, attributeSpec);
            long attrSize = attributeSpec.getAttributeForm().getSize(context);
            if (attrSize < 0L || attrSize > Integer.MAX_VALUE) {
                throw new IOException("Invalid attribute value size");
            }
            currentAttrOffset = (int)((long)currentAttrOffset + attrSize);
            reader.setPointerIndex(offset + (long)currentAttrOffset);
        }
        return new DebugInfoEntry(cu, offset, dieIndex, abbreviation, attrOffsets);
    }

    private DebugInfoEntry(DWARFCompilationUnit unit, long offset) {
        this(unit, offset, -1, null, null);
    }

    public DebugInfoEntry(DWARFCompilationUnit cu, long offset, int dieIndex, DWARFAbbreviation abbreviation, int[] attrOffsets) {
        this.compilationUnit = cu;
        this.offset = offset;
        this.dieIndex = dieIndex;
        this.abbreviation = abbreviation;
        this.attrOffsets = attrOffsets;
        this.attributes = attrOffsets != null ? new DWARFAttributeValue[attrOffsets.length] : null;
    }

    public int getIndex() {
        return this.dieIndex;
    }

    public List<DebugInfoEntry> getChildren() {
        return this.getProgram().getChildrenOf(this.dieIndex);
    }

    public List<DebugInfoEntry> getChildren(DWARFTag childTag) {
        List<DebugInfoEntry> children = this.getChildren();
        ArrayList<DebugInfoEntry> result = new ArrayList<DebugInfoEntry>(children.size());
        for (DebugInfoEntry child : children) {
            if (child.getTag() != childTag) continue;
            result.add(child);
        }
        return result;
    }

    public DebugInfoEntry getParent() {
        return this.getProgram().getParentOf(this.dieIndex);
    }

    public long getOffset() {
        return this.offset;
    }

    public DWARFTag getTag() {
        return this.abbreviation != null ? this.abbreviation.getTag() : null;
    }

    public int getAttributeCount() {
        return this.attrOffsets.length;
    }

    public DWARFAttributeValue getAttributeValue(int attribIndex) throws IOException {
        if (this.attributes[attribIndex] == null) {
            BinaryReader reader = this.getProgram().getReaderForCompUnit(this.compilationUnit).clone(this.offset + (long)this.attrOffsets[attribIndex]);
            DWARFFormContext context = new DWARFFormContext(reader, this.compilationUnit, this.abbreviation.getAttributeAt(attribIndex));
            this.attributes[attribIndex] = context.def().getAttributeForm().readValue(context);
        }
        return this.attributes[attribIndex];
    }

    public void setAttributeValue(int index, DWARFAttributeValue attrVal) {
        this.attributes[index] = attrVal;
    }

    private DWARFAttributeValue getAttributeValueUnchecked(int attribIndex) {
        try {
            return this.getAttributeValue(attribIndex);
        }
        catch (IOException e) {
            return null;
        }
    }

    public DWARFAttributeValue findAttribute(DWARFAttribute attributeId) {
        DWARFAttribute.AttrDef[] attrDefs = this.abbreviation.getAttributes();
        for (int i = 0; i < attrDefs.length; ++i) {
            DWARFAttribute.AttrDef attrDef = attrDefs[i];
            if (attrDef.getAttributeId() != attributeId) continue;
            return this.getAttributeValueUnchecked(i);
        }
        return null;
    }

    public DWARFAbbreviation getAbbreviation() {
        return this.abbreviation;
    }

    public boolean isTerminator() {
        return this.abbreviation == null;
    }

    public DWARFCompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public DWARFProgram getProgram() {
        return this.getCompilationUnit().getProgram();
    }

    public int getDepth() {
        return this.getProgram().getParentDepth(this.dieIndex);
    }

    public int hashCode() {
        return Objects.hash(this.compilationUnit, this.dieIndex, this.offset);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DebugInfoEntry)) {
            return false;
        }
        DebugInfoEntry other = (DebugInfoEntry)obj;
        return Objects.equals(this.compilationUnit, other.compilationUnit) && this.dieIndex == other.dieIndex && this.offset == other.offset;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        DWARFTag tag = this.getTag();
        int tagNum = tag != null ? tag.getId() : 0;
        int abbrNum = this.abbreviation != null ? this.abbreviation.getAbbreviationCode() : 0;
        int childCount = this.getProgram().getChildCount(this.dieIndex);
        buffer.append("<%d><%x>: %s [abbrev %d, tag %d, index %d, children %d]\n".formatted(new Object[]{this.getDepth(), this.offset, tag, abbrNum, tagNum, this.dieIndex, childCount}));
        if (this.isTerminator()) {
            return buffer.toString();
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            buffer.append("\t\t");
            DWARFAttributeValue attribVal = this.getAttributeValueUnchecked(i);
            if (attribVal != null) {
                buffer.append(attribVal.toString(this.compilationUnit));
            } else {
                DWARFAttribute.AttrDef attrDef = this.abbreviation.getAttributeAt(i);
                buffer.append("%s : %s = <missing>".formatted(new Object[]{attrDef.getAttributeName(), attrDef.getAttributeForm()}));
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

