/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.DebugInfoProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderStatus;
import ghidra.util.task.TaskMonitor;

public class DisabledDebugInfoProvider
implements DebugInfoProvider {
    private static String DISABLED_PREFIX = "disabled://";
    private DebugInfoProvider delegate;

    public static boolean matches(String name) {
        return name.startsWith(DISABLED_PREFIX);
    }

    public static DebugInfoProvider create(String name, DebugInfoProviderCreatorContext context) {
        String delegateName = name.substring(DISABLED_PREFIX.length());
        DebugInfoProvider delegate = context.registry().create(delegateName, context);
        return delegate != null ? new DisabledDebugInfoProvider(delegate) : null;
    }

    public DisabledDebugInfoProvider(DebugInfoProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName() {
        return DISABLED_PREFIX + this.delegate.getName();
    }

    @Override
    public String getDescriptiveName() {
        return "Disabled - " + this.delegate.getDescriptiveName();
    }

    public DebugInfoProvider getDelegate() {
        return this.delegate;
    }

    @Override
    public DebugInfoProviderStatus getStatus(TaskMonitor monitor) {
        return DebugInfoProviderStatus.UNKNOWN;
    }
}

