/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.DebugFileStorage;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderStatus;
import ghidra.app.util.bin.format.dwarf.external.DebugStreamProvider;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.ObjectType;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Date;
import java.util.Objects;
import utilities.util.FileUtilities;
import utility.application.ApplicationUtilities;

public class LocalDirDebugInfoDProvider
implements DebugFileStorage {
    private static final long MAINT_INTERVAL_MS = Duration.ofDays(1L).toMillis();
    public static final long MAX_FILE_AGE_MS = Duration.ofDays(7L).toMillis();
    private static final String DEBUGINFOD_NAME_PREFIX = "debuginfod-dir://";
    public static final String GHIDRACACHE_NAME = "$DEFAULT";
    public static final String USERHOMECACHE_NAME = "$DEBUGINFOD_CLIENT_CACHE";
    private final File rootDir;
    private final String name;
    private final String descriptiveName;
    private boolean needsInitMaintCheck;

    public static boolean matches(String name) {
        return name.startsWith(DEBUGINFOD_NAME_PREFIX);
    }

    public static LocalDirDebugInfoDProvider create(String name, DebugInfoProviderCreatorContext context) {
        if (USERHOMECACHE_NAME.equals(name = name.substring(DEBUGINFOD_NAME_PREFIX.length()))) {
            return LocalDirDebugInfoDProvider.getUserHomeCacheInstance();
        }
        if (GHIDRACACHE_NAME.equals(name)) {
            return LocalDirDebugInfoDProvider.getGhidraCacheInstance();
        }
        return new LocalDirDebugInfoDProvider(new File(name));
    }

    public static LocalDirDebugInfoDProvider getUserHomeCacheInstance() {
        File cacheDir = new File(LocalDirDebugInfoDProvider.getCacheHomeLocation(), "debuginfod_client");
        return new LocalDirDebugInfoDProvider(cacheDir, "debuginfod-dir://$DEBUGINFOD_CLIENT_CACHE", "DebugInfoD Cache Dir <%s>".formatted(cacheDir));
    }

    public static LocalDirDebugInfoDProvider getGhidraCacheInstance() {
        File cacheDir = new File(Application.getUserCacheDirectory(), "debuginfo-cache");
        FileUtilities.mkdirs((File)cacheDir);
        LocalDirDebugInfoDProvider result = new LocalDirDebugInfoDProvider(cacheDir, "debuginfod-dir://$DEFAULT", "Ghidra Cache Dir <%s>".formatted(cacheDir));
        result.setNeedsMaintCheck(true);
        return result;
    }

    public LocalDirDebugInfoDProvider(File rootDir) {
        this(rootDir, DEBUGINFOD_NAME_PREFIX + rootDir.getPath(), rootDir.getPath() + " (debuginfod dir)");
    }

    public LocalDirDebugInfoDProvider(File rootDir, String name, String descriptiveName) {
        this.rootDir = rootDir;
        this.name = name;
        this.descriptiveName = descriptiveName;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    @Override
    public DebugInfoProviderStatus getStatus(TaskMonitor monitor) {
        return this.isValid() ? DebugInfoProviderStatus.VALID : DebugInfoProviderStatus.INVALID;
    }

    public File getDirectory() {
        return this.rootDir;
    }

    private boolean isValid() {
        return this.rootDir.isDirectory();
    }

    public void setNeedsMaintCheck(boolean needsInitMaintCheck) {
        this.needsInitMaintCheck = needsInitMaintCheck;
    }

    @Override
    public File getFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.isValid() || !debugInfo.hasBuildId()) {
            return null;
        }
        this.performInitMaintIfNeeded();
        File f = this.getCachePath(debugInfo);
        if (f.isFile()) {
            f.setLastModified(System.currentTimeMillis());
            return f;
        }
        return null;
    }

    private File getBuildidDir(String buildId) {
        return new File(this.rootDir, buildId);
    }

    private File getCachePath(ExternalDebugInfo id) {
        Object suffix = "";
        if (id.getObjectType() == ObjectType.SOURCE) {
            suffix = "-" + LocalDirDebugInfoDProvider.escapePath(Objects.requireNonNullElse(id.getExtra(), ""));
        }
        return new File(this.getBuildidDir(id.getBuildId()), id.getObjectType().getPathString() + (String)suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File putStream(ExternalDebugInfo id, DebugStreamProvider.StreamInfo stream, TaskMonitor monitor) throws IOException, CancelledException {
        this.assertValid();
        if (!id.hasBuildId()) {
            throw new IOException("Can't store debug file without BuildId value: " + String.valueOf(id));
        }
        this.performInitMaintIfNeeded();
        File f = this.getCachePath(id);
        File tmpF = new File(f.getParentFile(), ".tmp_" + f.getName());
        FileUtilities.checkedMkdirs((File)f.getParentFile());
        try (DebugStreamProvider.StreamInfo streamInfo = stream;
             FileOutputStream fos = new FileOutputStream(tmpF);){
            FSUtilities.streamCopy(stream.is(), fos, monitor);
        }
        try {
            if (f.isFile() && !f.delete()) {
                throw new IOException("Could not delete %s".formatted(f));
            }
            if (!tmpF.renameTo(f)) {
                throw new IOException("Could not rename temp file %s to %s".formatted(tmpF, f));
            }
        }
        finally {
            tmpF.delete();
        }
        return f;
    }

    private void assertValid() throws IOException {
        if (!this.rootDir.isDirectory()) {
            throw new IOException("Invalid debuginfo directory: " + String.valueOf(this.rootDir));
        }
    }

    public String toString() {
        return String.format("LocalDebugInfoProvider [rootDir=%s, name=%s]", this.rootDir, this.name);
    }

    public void purgeAll() {
        this.cacheMaint(-1L);
        File lastMaintFile = new File(this.rootDir, ".lastmaint");
        lastMaintFile.delete();
    }

    public void performInitMaintIfNeeded() {
        if (this.needsInitMaintCheck) {
            try {
                this.performCacheMaintIfNeeded();
            }
            finally {
                this.needsInitMaintCheck = false;
            }
        }
    }

    public void performCacheMaintIfNeeded() {
        long lastMaintTS;
        if (!this.rootDir.isDirectory()) {
            return;
        }
        if (this.rootDir.getParentFile() == null) {
            Msg.error((Object)this, (Object)("Refusing to clean up files in " + String.valueOf(this.rootDir)));
            return;
        }
        long now = System.currentTimeMillis();
        File lastMaintFile = new File(this.rootDir, ".lastmaint");
        long l = lastMaintTS = lastMaintFile.isFile() ? lastMaintFile.lastModified() : 0L;
        if (lastMaintTS + MAINT_INTERVAL_MS > now) {
            return;
        }
        this.cacheMaint(MAX_FILE_AGE_MS);
        try {
            Files.writeString(lastMaintFile.toPath(), (CharSequence)("Last maint run at " + String.valueOf(new Date())), new OpenOption[0]);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Unable to write file cache maintenance file: " + String.valueOf(lastMaintFile)), (Throwable)e);
        }
    }

    private void cacheMaint(long maxFileAgeMs) {
        long cutoffMS = maxFileAgeMs >= 0L ? System.currentTimeMillis() - maxFileAgeMs : Long.MAX_VALUE;
        int deletedCount = 0;
        long deletedBytes = 0L;
        for (File f : Objects.requireNonNullElse(this.rootDir.listFiles(), new File[0])) {
            if (!f.isDirectory() || !LocalDirDebugInfoDProvider.isBuildIdSubdirName(f.getName())) continue;
            int subDirFileCount = 0;
            int deletedSubDirFileCount = 0;
            for (File subF : Objects.requireNonNullElse(f.listFiles(), new File[0])) {
                long modified;
                ++subDirFileCount;
                if (!subF.isFile() || (modified = subF.lastModified()) == 0L || modified >= cutoffMS) continue;
                long size = subF.length();
                if (!subF.delete()) continue;
                ++deletedCount;
                deletedBytes += size;
                ++deletedSubDirFileCount;
            }
            if (subDirFileCount != deletedSubDirFileCount || f.delete()) continue;
            Msg.warn((Object)this, (Object)("Failed to delete empty debuginfod hash directory: " + String.valueOf(f)));
        }
        Msg.debug((Object)this, (Object)"Finished cache cleanup of debug files in %s, deleted %d files, %d total bytes".formatted(this.rootDir, deletedCount, deletedBytes));
    }

    private static String escapePath(String s) {
        int maxPath = 127;
        int hash = (int)LocalDirDebugInfoDProvider.djbX33AHash(s);
        if (s.length() > maxPath) {
            int start = s.length() - maxPath;
            s = s.substring(start);
        }
        s = s.replaceAll("[^a-zA-Z0-9._-]", "#");
        return "%08x-%s".formatted(hash, s);
    }

    private static long djbX33AHash(String s) {
        long hash = 5381L;
        for (byte b : s.getBytes(StandardCharsets.UTF_8)) {
            hash = (hash << 5) + hash + (long)Byte.toUnsignedInt(b);
        }
        return hash;
    }

    private static boolean isBuildIdSubdirName(String s) {
        byte[] bytes = NumericUtilities.convertStringToBytes((String)s);
        return bytes != null && bytes.length >= 20;
    }

    private static File getCacheHomeLocation() {
        File cacheHomeDir = LocalDirDebugInfoDProvider.getEnvVarAsFile("XDG_CACHE_HOME");
        if (cacheHomeDir == null) {
            try {
                cacheHomeDir = ApplicationUtilities.getJavaUserHomeDir();
            }
            catch (IOException e) {
                throw new RuntimeException("Missing home directory", e);
            }
            cacheHomeDir = new File(cacheHomeDir, ".cache");
        }
        return cacheHomeDir;
    }

    private static File getEnvVarAsFile(String name) {
        File result;
        String path = System.getenv(name);
        if (path != null && !path.isBlank() && (result = new File(path.trim())).isAbsolute()) {
            return result;
        }
        return null;
    }
}

