/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external.gui;

import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.GIcon;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderStatus;
import ghidra.app.util.bin.format.dwarf.external.gui.EnumIconColumnRenderer;
import ghidra.app.util.bin.format.dwarf.external.gui.ExternalDebugInfoProviderTableRow;
import ghidra.app.util.bin.format.dwarf.external.gui.TableColumnInitializer;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.TableColumn;
import resources.Icons;

class ExternalDebugInfoProviderTableModel
extends GDynamicColumnTableModel<ExternalDebugInfoProviderTableRow, List<ExternalDebugInfoProviderTableRow>> {
    private List<ExternalDebugInfoProviderTableRow> rows = new ArrayList<ExternalDebugInfoProviderTableRow>();
    private boolean dataChanged;

    ExternalDebugInfoProviderTableModel() {
        super((ServiceProvider)new ServiceProviderStub());
        this.setDefaultTableSortState(null);
    }

    boolean isEmpty() {
        return this.rows.isEmpty();
    }

    void setItems(List<DebugInfoProvider> newItems) {
        this.rows.clear();
        for (DebugInfoProvider item : newItems) {
            this.rows.add(new ExternalDebugInfoProviderTableRow(item));
        }
        this.fireTableDataChanged();
    }

    List<DebugInfoProvider> getItems() {
        return this.rows.stream().map(ExternalDebugInfoProviderTableRow::getItem).toList();
    }

    void addItem(DebugInfoProvider newItem) {
        ExternalDebugInfoProviderTableRow row = new ExternalDebugInfoProviderTableRow(newItem);
        this.rows.add(row);
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    void addItems(List<DebugInfoProvider> newItems) {
        for (DebugInfoProvider item : newItems) {
            this.rows.add(new ExternalDebugInfoProviderTableRow(item));
        }
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    void deleteRows(int[] rowIndexes) {
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.rows.remove(rowIndexes[i]);
        }
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    void moveRow(int rowIndex, int deltaIndex) {
        int destIndex = rowIndex + deltaIndex;
        if (rowIndex < 0 || rowIndex >= this.rows.size() || destIndex < 0 || destIndex >= this.rows.size()) {
            return;
        }
        ExternalDebugInfoProviderTableRow row1 = this.rows.get(rowIndex);
        ExternalDebugInfoProviderTableRow row2 = this.rows.get(destIndex);
        this.rows.set(destIndex, row1);
        this.rows.set(rowIndex, row2);
        this.dataChanged = true;
        this.fireTableDataChanged();
    }

    boolean isDataChanged() {
        return this.dataChanged;
    }

    void setDataChanged(boolean b) {
        this.dataChanged = b;
    }

    public String getName() {
        return "External Debug Info Providers";
    }

    public List<ExternalDebugInfoProviderTableRow> getModelData() {
        return this.rows;
    }

    public List<ExternalDebugInfoProviderTableRow> getDataSource() {
        return this.rows;
    }

    public boolean isSortable(int columnIndex) {
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        if (column instanceof EnabledColumn && aValue instanceof Boolean) {
            Boolean boolVal = (Boolean)aValue;
            ExternalDebugInfoProviderTableRow row = (ExternalDebugInfoProviderTableRow)this.getRowObject(rowIndex);
            row.setEnabled(boolVal);
            this.dataChanged = true;
            this.fireTableDataChanged();
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        return column instanceof EnabledColumn;
    }

    protected TableColumnDescriptor<ExternalDebugInfoProviderTableRow> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new EnabledColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new StatusColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new LocationColumn(this));
        return descriptor;
    }

    static class EnabledColumn
    extends AbstractDynamicTableColumnStub<ExternalDebugInfoProviderTableRow, Boolean>
    implements TableColumnInitializer {
        EnabledColumn() {
        }

        public String getColumnDisplayName(Settings settings) {
            return "Enabled";
        }

        public Boolean getValue(ExternalDebugInfoProviderTableRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isEnabled();
        }

        public String getColumnName() {
            return "Enabled";
        }

        @Override
        public void initializeTableColumn(TableColumn col, FontMetrics fm, int padding) {
            int colWidth = fm.stringWidth("Enabled") + padding;
            col.setPreferredWidth(colWidth);
            col.setMaxWidth(colWidth * 2);
            col.setMinWidth(colWidth);
        }
    }

    private static class StatusColumn
    extends AbstractDynamicTableColumnStub<ExternalDebugInfoProviderTableRow, DebugInfoProviderStatus>
    implements TableColumnInitializer {
        private static final Icon VALID_ICON = new GIcon("icon.checkmark.green");
        private static final Icon INVALID_ICON = Icons.ERROR_ICON;
        private static Icon[] icons = new Icon[]{null, VALID_ICON, INVALID_ICON};
        private static String[] toolTips = new String[]{null, "Status: Ok", "Status: Failed"};
        EnumIconColumnRenderer<DebugInfoProviderStatus> renderer = new EnumIconColumnRenderer<DebugInfoProviderStatus>(DebugInfoProviderStatus.class, icons, toolTips);

        private StatusColumn() {
        }

        public DebugInfoProviderStatus getValue(ExternalDebugInfoProviderTableRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getStatus();
        }

        public String getColumnDisplayName(Settings settings) {
            return "Status";
        }

        public String getColumnName() {
            return "Status";
        }

        public GColumnRenderer<DebugInfoProviderStatus> getColumnRenderer() {
            return this.renderer;
        }

        @Override
        public void initializeTableColumn(TableColumn col, FontMetrics fm, int padding) {
            int colWidth = fm.stringWidth("Status") + padding;
            col.setPreferredWidth(colWidth);
            col.setMaxWidth(colWidth * 2);
            col.setMinWidth(colWidth);
        }
    }

    private class LocationColumn
    extends AbstractDynamicTableColumnStub<ExternalDebugInfoProviderTableRow, String> {
        private LocationColumn(ExternalDebugInfoProviderTableModel externalDebugInfoProviderTableModel) {
        }

        public String getValue(ExternalDebugInfoProviderTableRow rowObject, Settings settings, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getItem().getDescriptiveName();
        }

        public String getColumnName() {
            return "Location";
        }

        public int getColumnPreferredWidth() {
            return 250;
        }
    }
}

