/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external.gui;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import utilities.util.FileUtilities;

public record WellKnownDebugProvider(String location, String locationCategory, String warning, String fileOrigin) {
    public static List<WellKnownDebugProvider> loadAll(String fileExt) {
        List files = Application.findFilesByExtensionInApplication((String)fileExt);
        HashSet<WellKnownDebugProvider> seenProviders = new HashSet<WellKnownDebugProvider>();
        ArrayList<WellKnownDebugProvider> results = new ArrayList<WellKnownDebugProvider>();
        for (ResourceFile file : files) {
            try {
                List lines = FileUtilities.getLines((ResourceFile)file);
                for (String line : lines) {
                    WellKnownDebugProvider provider;
                    String[] fields = line.split("\\|");
                    if (fields.length <= 1 || !seenProviders.add(provider = new WellKnownDebugProvider(fields[1], fields[0], fields.length > 2 ? fields[2] : null, file.getName()))) continue;
                    results.add(provider);
                }
            }
            catch (IOException e) {
                Msg.warn(WellKnownDebugProvider.class, (Object)("Unable to read file: " + String.valueOf(file)));
            }
        }
        return results;
    }
}

