/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImport;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImports;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldChainedFixups {
    public static final int RELOCATION_TYPE = 34952;

    public static List<DyldFixup> getChainedFixups(BinaryReader reader, DyldChainedImports chainedImports, DyldChainedPtr.DyldChainType pointerFormat, long page, long nextOff, long auth_value_add, long imagebase, SymbolTable symbolTable, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>();
        long next = -1L;
        while (next != 0L) {
            monitor.checkCancelled();
            long chainLoc = page + nextOff;
            long chainValue = DyldChainedPtr.getChainValue(reader, chainLoc, pointerFormat);
            Long newChainValue = chainValue;
            boolean isAuthenticated = DyldChainedPtr.isAuthenticated(pointerFormat, chainValue);
            boolean isBound = DyldChainedPtr.isBound(pointerFormat, chainValue);
            String symbol = null;
            Integer libOrdinal = null;
            if (isBound) {
                if (chainedImports == null) {
                    log.appendMsg("Error: dyld_chained_import array required to process bound chain fixup at " + chainLoc);
                    return List.of();
                }
                if (symbolTable == null) {
                    log.appendMsg("Error: symbol table required to process bound chain fixup at " + chainLoc);
                    return List.of();
                }
                int chainOrdinal = (int)DyldChainedPtr.getOrdinal(pointerFormat, chainValue);
                long addend = DyldChainedPtr.getAddend(pointerFormat, chainValue);
                DyldChainedImport chainedImport = chainedImports.getChainedImport(chainOrdinal);
                symbol = SymbolUtilities.replaceInvalidChars((String)chainedImport.getName(), (boolean)true);
                libOrdinal = chainedImport.getLibOrdinal();
                List globalSymbols = symbolTable.getGlobalSymbols(symbol);
                if (globalSymbols.size() > 0) {
                    newChainValue = ((Symbol)globalSymbols.getFirst()).getAddress().getOffset();
                    newChainValue = newChainValue + (isAuthenticated ? auth_value_add : addend);
                } else {
                    newChainValue = null;
                }
            } else if (isAuthenticated) {
                newChainValue = imagebase + DyldChainedPtr.getTarget(pointerFormat, chainValue) + auth_value_add;
            } else {
                newChainValue = DyldChainedPtr.getTarget(pointerFormat, chainValue);
                if (DyldChainedPtr.isRelative(pointerFormat)) {
                    newChainValue = newChainValue + imagebase;
                }
            }
            fixups.add(new DyldFixup(chainLoc, newChainValue, DyldChainedPtr.getSize(pointerFormat), symbol, libOrdinal));
            next = DyldChainedPtr.getNext(pointerFormat, chainValue);
            nextOff += next * DyldChainedPtr.getStride(pointerFormat);
        }
        return fixups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Address> fixupChainedPointers(List<DyldFixup> fixups, Program program, Address imagebase, List<String> libraryPaths, MessageLog log, TaskMonitor monitor) throws CancelledException {
        if (fixups.isEmpty()) {
            return List.of();
        }
        Memory memory = program.getMemory();
        SymbolTable symbolTable = program.getSymbolTable();
        ExternalManager extMgr = program.getExternalManager();
        Address extAddr = null;
        try {
            long externalSize = fixups.stream().filter(e -> e.value() == null && e.symbol() != null && e.libOrdinal() != null).mapToLong(DyldFixup::size).sum();
            if (externalSize > 0L) {
                extAddr = MemoryBlockUtils.addExternalBlock(program, externalSize, log);
            }
        }
        catch (Exception e2) {
            log.appendMsg("Failed to create space in EXTERNAL block for chained fixups: " + e2.getMessage());
        }
        ArrayList<Address> fixedAddrs = new ArrayList<Address>();
        monitor.initialize((long)fixups.size(), "Fixing up chained pointers...");
        for (DyldFixup fixup : fixups) {
            monitor.increment();
            Relocation.Status status = Relocation.Status.UNSUPPORTED;
            Address fixupAddr = imagebase.add(fixup.offset());
            Long fixupValue = fixup.value();
            String fixupSymbol = fixup.symbol();
            long[] value = new long[]{};
            try {
                if (fixupValue == null && fixupSymbol != null && fixup.libOrdinal() != null && extAddr != null) {
                    try {
                        symbolTable.createLabel(extAddr, fixupSymbol, SourceType.IMPORTED);
                        fixupValue = extAddr.getOffset();
                        Function stubFunc = MachoProgramBuilder.createOneByteFunction(program, fixupSymbol, extAddr);
                        if (stubFunc != null) {
                            ExternalLocation loc = extMgr.addExtLocation("<EXTERNAL>", fixupSymbol, null, SourceType.IMPORTED);
                            stubFunc.setThunkedFunction(loc.createFunction());
                        }
                    }
                    finally {
                        extAddr = extAddr.add((long)fixup.size());
                    }
                }
                if (fixupValue != null) {
                    if (fixup.size() == 8 || fixup.size() == 4) {
                        if (fixup.size() == 8) {
                            memory.setLong(fixupAddr, fixupValue.longValue());
                        } else {
                            memory.setInt(fixupAddr, fixupValue.intValue());
                        }
                        fixedAddrs.add(fixupAddr);
                        status = Relocation.Status.APPLIED;
                    }
                    value = new long[]{fixupValue};
                }
                if (fixupSymbol == null || fixup.libOrdinal() == null) continue;
                value = new long[]{fixup.libOrdinal().intValue()};
                try {
                    MachoProgramBuilder.fixupExternalLibrary(program, libraryPaths, fixup.libOrdinal(), fixupSymbol);
                }
                catch (Exception e3) {
                    log.appendMsg("WARNING: Problem fixing up symbol '%s' - %s".formatted(fixupSymbol, e3.getMessage()));
                }
            }
            catch (Exception e4) {
                status = Relocation.Status.FAILURE;
            }
            finally {
                program.getRelocationTable().add(fixupAddr, status, 34952, value, fixup.size(), fixupSymbol);
            }
        }
        log.appendMsg("Fixed up " + fixedAddrs.size() + " chained pointers.");
        return fixedAddrs;
    }

    public static List<DyldFixup> processPointerChain(BinaryReader reader, long chainStart, long nextOffSize, long imagebase, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        long BIT63 = Long.MIN_VALUE;
        long BIT62 = 0x4000000000000000L;
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>();
        while (true) {
            monitor.checkCancelled();
            long chainValue = reader.readLong(chainStart);
            long fixedPointerValue = 0L;
            if ((chainValue & 0x4000000000000000L) != 0L) {
                // empty if block
            }
            if ((chainValue & Long.MIN_VALUE) != 0L) {
                fixedPointerValue = imagebase + (chainValue & 0xFFFFFFFFL);
            } else {
                fixedPointerValue = chainValue << 13 & 0xFF00000000000000L | chainValue & 0x7FFFFFFFFFFL;
                if ((chainValue & 0x40000000000L) != 0L) {
                    fixedPointerValue |= 0xFFFC0000000000L;
                }
            }
            fixups.add(new DyldFixup(chainStart, fixedPointerValue, 8, null, null));
            long nextValueOff = (chainValue >> 51 & 0x7FFL) * nextOffSize;
            if (nextValueOff == 0L) break;
            chainStart += nextValueOff;
        }
        return fixups;
    }
}

