/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.task.TaskMonitor;

public abstract class ObjcMethod
extends ObjcTypeMetadataStructure {
    protected ObjcMethodType _methodType;

    public ObjcMethod(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType) {
        super(program, state, reader.getPointerIndex());
        this._methodType = methodType;
    }

    public final ObjcMethodType getMethodType() {
        return this._methodType;
    }

    public abstract String getName();

    public abstract String getTypes();

    public abstract long getImplementation();

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        long implementation = this.getImplementation();
        if (implementation == 0L) {
            return;
        }
        if (this.getName() == null || this.getName().length() == 0) {
            return;
        }
        boolean isThumbCode = ObjcUtils.isThumb(this.program, implementation);
        if (isThumbCode) {
            --implementation;
        }
        Address implementationAddress = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(implementation);
        ObjcUtils.createSymbol(this.program, namespace, this.getName(), implementationAddress);
        this.state.methodMap.put(implementationAddress, this);
        if (isThumbCode) {
            this.state.thumbCodeLocations.add(implementationAddress);
        }
    }
}

