/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.task.TaskMonitor;

public abstract class ObjcTypeMetadataStructure
implements StructConverter {
    public static final String DATA_TYPE_CATEGORY = "/ObjcTypeMetadata";
    protected Program program;
    protected ObjcState state;
    protected long base;
    protected int pointerSize;
    protected boolean is32bit;
    protected boolean isArm;

    public ObjcTypeMetadataStructure(Program program, ObjcState state, long base) {
        this.program = program;
        this.state = state;
        this.base = base;
        this.pointerSize = program.getDefaultPointerSize();
        this.is32bit = this.pointerSize == 4;
        this.isArm = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"));
    }

    public Program getProgram() {
        return this.program;
    }

    public long getBase() {
        return this.base;
    }

    public ObjcState getState() {
        return this.state;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public boolean is32bit() {
        return this.is32bit;
    }

    public boolean isArm() {
        return this.isArm;
    }

    public abstract void applyTo(Namespace var1, TaskMonitor var2) throws Exception;

    public String toString() {
        return "%s at 0x%x".formatted(this.getClass().getSimpleName(), this.base);
    }
}

