/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.register.SetRegisterCmd;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethod;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.symbol.ClassSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ObjcUtils {
    public static long readNextIndex(BinaryReader reader, boolean is32bit) throws IOException {
        return is32bit ? reader.readNextUnsignedInt() : reader.readNextLong();
    }

    public static String dereferenceAsciiString(BinaryReader reader, boolean is32bit) throws IOException {
        long stringIndex = ObjcUtils.readNextIndex(reader, is32bit);
        return stringIndex != 0L ? reader.readAsciiString(stringIndex) : null;
    }

    public static boolean isThumb(Program program, Address address) {
        MemoryBlock block;
        Processor ARM = Processor.findOrPossiblyCreateProcessor((String)"ARM");
        if (program.getLanguage().getProcessor().equals((Object)ARM) && (block = program.getMemory().getBlock(address)) != null && block.isExecute()) {
            return address.getOffset() % 2L != 0L;
        }
        return false;
    }

    public static boolean isThumb(Program program, long address) {
        return ObjcUtils.isThumb(program, ObjcUtils.toAddress(program, address));
    }

    public static void setThumbBit(Program program, ObjcState state, Address address) {
        Register tmodeRegister;
        if (state.thumbCodeLocations.contains(address) && (tmodeRegister = program.getLanguage().getRegister("TMode")) != null) {
            SetRegisterCmd c = new SetRegisterCmd(tmodeRegister, address, address, BigInteger.valueOf(1L));
            c.applyTo((DomainObject)program);
        }
    }

    public static Address toAddress(Program program, long offset) {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }

    public static Data createData(Program program, DataType dt, Address address) throws CodeUnitInsertionException {
        Data data = program.getListing().getDefinedDataAt(address);
        if (data != null && data.getDataType().isEquivalent(dt)) {
            return data;
        }
        return DataUtilities.createData((Program)program, (Address)address, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
    }

    public static String createString(Program program, Address address) {
        Data data = program.getListing().getDataAt(address);
        if (data == null) {
            CreateDataCmd cmd = new CreateDataCmd(address, (DataType)new StringDataType());
            cmd.applyTo(program);
            data = program.getListing().getDefinedDataAt(address);
        }
        if (data == null) {
            return null;
        }
        Object object = data.getValue();
        if (object instanceof String) {
            String str = (String)object;
            return str;
        }
        Msg.error(null, (Object)("Unable to locate string at " + String.valueOf(address)));
        return null;
    }

    private static Namespace getNamespace(Program program, Namespace parentNamespace, String namespaceName) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = symbolTable.getNamespace(namespaceName, parentNamespace);
        if (namespace != null) {
            return namespace;
        }
        return symbolTable.createNameSpace(parentNamespace, namespaceName, SourceType.IMPORTED);
    }

    public static Namespace getClassNamespace(Program program, Namespace parentNamespace, String namespaceName) throws DuplicateNameException, InvalidInputException {
        ClassSymbol clsSymbol;
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getClassSymbol(namespaceName, parentNamespace);
        if (symbol instanceof ClassSymbol && (clsSymbol = (ClassSymbol)symbol).getName().equals(namespaceName)) {
            return clsSymbol.getObject();
        }
        return symbolTable.createClass(parentNamespace, namespaceName, SourceType.IMPORTED);
    }

    public static Symbol createSymbol(Program program, Namespace parentNamespace, String symbolName, Address symbolAddress) throws InvalidInputException {
        Symbol symbol = program.getSymbolTable().createLabel(symbolAddress, symbolName, parentNamespace, SourceType.IMPORTED);
        symbol.setPrimary();
        return symbol;
    }

    public static Namespace createNamespace(Program program, String ... namespacePath) throws DuplicateNameException, InvalidInputException {
        Namespace parentNamespace = program.getGlobalNamespace();
        Namespace namespace = null;
        for (String namespaceName : namespacePath) {
            parentNamespace = namespace = ObjcUtils.getNamespace(program, parentNamespace, namespaceName);
        }
        return namespace;
    }

    public static final void createMethods(Program program, ObjcState state, MessageLog log, TaskMonitor monitor) {
        monitor.initialize((long)state.methodMap.size(), "Creating Objective-C Methods...");
        Set<Address> addresses = state.methodMap.keySet();
        for (Address address : addresses) {
            if (monitor.isCancelled()) break;
            monitor.incrementProgress();
            ObjcUtils.setThumbBit(program, state, address);
            BackgroundCommand command = null;
            command = new DisassembleCommand(address, null, true);
            command.applyTo((DomainObject)program, monitor);
            command = new CreateFunctionCmd(address);
            command.applyTo((DomainObject)program, monitor);
            ObjcMethod method = state.methodMap.get(address);
            try {
                state.encodings.processMethodSignature(program, address, method.getTypes(), method.getMethodType());
            }
            catch (Exception e) {
                Msg.error(ObjcUtils.class, (Object)("Unhandled method signature: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static final void fixupReferences(List<String> sectionNames, Program program, TaskMonitor monitor) {
        AddressSet addressSet = new AddressSet();
        sectionNames.stream().map(arg_0 -> ((Memory)program.getMemory()).getBlock(arg_0)).filter(Objects::nonNull).forEach(b -> addressSet.addRange(b.getStart(), b.getEnd()));
        monitor.initialize(addressSet.getNumAddresses(), "Fixing References...");
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator referenceIterator = referenceManager.getReferenceSourceIterator((AddressSetView)addressSet, true);
        block0: while (referenceIterator.hasNext() && !monitor.isCancelled()) {
            Reference[] references;
            monitor.incrementProgress();
            Address sourceAddress = referenceIterator.next();
            for (Reference reference : references = referenceManager.getReferencesFrom(sourceAddress)) {
                if (monitor.isCancelled()) continue block0;
                if (reference.getToAddress().getOffset() == 0L) {
                    referenceManager.delete(reference);
                }
                if (!ObjcUtils.isThumb(program, reference.getToAddress())) continue;
                referenceManager.delete(reference);
                referenceManager.addMemoryReference(reference.getFromAddress(), reference.getToAddress().subtract(1L), reference.getReferenceType(), reference.getSource(), reference.getOperandIndex());
            }
        }
    }

    public static void setBlocksReadOnly(Memory memory, List<String> blockNames) {
        blockNames.stream().map(n -> memory.getBlock(n)).filter(Objects::nonNull).forEach(b -> b.setWrite(false));
    }

    public static List<MemoryBlock> getObjcBlocks(String section, Program program) {
        return Arrays.stream(program.getMemory().getBlocks()).filter(b -> b.getName().equals(section)).toList();
    }
}

