/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1MethodList;
import ghidra.app.util.bin.format.objc.objc1.Objc1ProtocolList;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc1Category
extends ObjcTypeMetadataStructure {
    public static final long SIZEOF = 0L;
    private String category_name;
    private String class_name;
    private Objc1MethodList instance_methods;
    private Objc1MethodList class_methods;
    private Objc1ProtocolList protocols;
    private int unknown0;
    private int unknown1;

    public Objc1Category(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.category_name = reader.readAsciiString(reader.readNextInt());
        this.class_name = reader.readAsciiString(reader.readNextInt());
        this.instance_methods = new Objc1MethodList(program, state, reader.clone(reader.readNextInt()), ObjcMethodType.INSTANCE);
        this.class_methods = new Objc1MethodList(program, state, reader.clone(reader.readNextInt()), ObjcMethodType.CLASS);
        this.protocols = new Objc1ProtocolList(program, state, reader.clone(reader.readNextInt()));
        if (this.isArm) {
            this.unknown0 = reader.readNextInt();
            this.unknown1 = reader.readNextInt();
        }
    }

    public String getCategoryName() {
        return this.category_name;
    }

    public String getClassName() {
        return this.class_name;
    }

    public Objc1MethodList getInstanceMethods() {
        return this.instance_methods;
    }

    public Objc1MethodList getClassMethods() {
        return this.class_methods;
    }

    public Objc1ProtocolList getProtocols() {
        return this.protocols;
    }

    public int getUnknown0() {
        return this.unknown0;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "objc_category";
        StructureDataType struct = new StructureDataType(name, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "category_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "class_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1MethodList.toGenericDataType(this.pointerSize), (int)this.pointerSize), "instance_methods", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1MethodList.toGenericDataType(this.pointerSize), (int)this.pointerSize), "class_methods", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1ProtocolList.toGenericDataType(this.pointerSize), (int)this.pointerSize), "protocols", null);
        if (this.isArm) {
            struct.add(DWORD, "unknown0", null);
            struct.add(DWORD, "unknown1", null);
        }
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        this.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this.program.getListing().createData(address, dt);
        Namespace categoryNamespace = ObjcUtils.createNamespace(this.program, "objc", "Categories", this.class_name + "(" + this.category_name + ")");
        this.instance_methods.applyTo(categoryNamespace, monitor);
        this.class_methods.applyTo(categoryNamespace, monitor);
        this.protocols.applyTo(namespace, monitor);
    }
}

