/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethod;
import ghidra.app.util.bin.format.objc.ObjcMethodList;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1Method;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Objc1MethodList
extends ObjcMethodList {
    public static final String NAME = "objc_method_list";
    private Objc1MethodList obsolete;
    private int method_count;

    Objc1MethodList(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType) throws IOException {
        super(program, state, reader, NAME);
        if (this.base == 0L) {
            return;
        }
        this.obsolete = new Objc1MethodList(program, state, reader.clone(reader.readNextInt()), methodType);
        this.method_count = reader.readNextInt();
        for (int i = 0; i < this.method_count; ++i) {
            this.methods.add(new Objc1Method(program, state, reader, methodType));
        }
    }

    public Objc1MethodList getObsolete() {
        return this.obsolete;
    }

    public int getMethodCount() {
        return this.method_count;
    }

    public static DataType toGenericDataType(int pointerSize) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)struct, (int)pointerSize), "obsolete", null);
        struct.add(DWORD, "method_count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_method_list_" + this.method_count + "_", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        if (this.obsolete == null) {
            struct.add((DataType)PointerDataType.getPointer((DataType)VOID, (int)this.pointerSize), "obsolete", null);
        } else {
            DataType obsoleteDT = this.obsolete.toDataType();
            struct.add((DataType)PointerDataType.getPointer((DataType)obsoleteDT, (int)this.pointerSize), "obsolete", null);
        }
        struct.add(DWORD, "method_count", null);
        if (this.method_count > 0) {
            DataType dt = ((ObjcMethod)this.methods.get(0)).toDataType();
            struct.add((DataType)new ArrayDataType(dt, this.method_count, dt.getLength()), "method_list", null);
        }
        return struct;
    }
}

