/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1ProtocolList;
import ghidra.app.util.bin.format.objc.objc1.Objc1ProtocolMethodList;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc1Protocol
extends ObjcTypeMetadataStructure {
    public static final String NAME = "objc_protocol";
    public static final int SIZEOF = 20;
    private int isa;
    private String name;
    private Objc1ProtocolList protocolList;
    private Objc1ProtocolMethodList instanceMethods;
    private Objc1ProtocolMethodList classMethods;

    public Objc1Protocol(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.isa = reader.readNextInt();
        this.name = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        this.protocolList = new Objc1ProtocolList(program, state, reader.clone(reader.readNextInt()));
        this.instanceMethods = new Objc1ProtocolMethodList(program, state, reader.clone(reader.readNextInt()), ObjcMethodType.INSTANCE);
        this.classMethods = new Objc1ProtocolMethodList(program, state, reader.clone(reader.readNextInt()), ObjcMethodType.CLASS);
    }

    public int getIsa() {
        return this.isa;
    }

    public String getName() {
        return this.name;
    }

    public Objc1ProtocolList getProtocolList() {
        return this.protocolList;
    }

    public Objc1ProtocolMethodList getInstanceMethods() {
        return this.instanceMethods;
    }

    public Objc1ProtocolMethodList getClassMethods() {
        return this.classMethods;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "isa", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1ProtocolList.toGenericDataType(this.pointerSize), (int)this.pointerSize), "protocolList", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1ProtocolMethodList.toGenericDataType(this.state), (int)this.pointerSize), "instanceMethods", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)Objc1ProtocolMethodList.toGenericDataType(this.state), (int)this.pointerSize), "classMethods", null);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        this.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this.program.getListing().createData(address, dt);
        this.protocolList.applyTo(namespace, monitor);
        this.instanceMethods.applyTo(namespace, monitor);
        this.classMethods.applyTo(namespace, monitor);
    }
}

