/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc1ProtocolMethod
extends ObjcTypeMetadataStructure {
    private static final String NAME = "objc_protocol_method";
    private ObjcMethodType _methodType;
    private String name;
    private String types;

    Objc1ProtocolMethod(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType) throws IOException {
        super(program, state, reader.getPointerIndex());
        this._methodType = methodType;
        this.name = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
        this.types = ObjcUtils.dereferenceAsciiString(reader, this.is32bit);
    }

    public String getName() {
        return this.name;
    }

    public String getTypes() {
        return this.types;
    }

    public ObjcMethodType getMethodType() {
        return this._methodType;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this.pointerSize), "types", null);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
    }
}

