/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.objc1.Objc1Constants;
import ghidra.app.util.bin.format.objc.objc1.Objc1ProtocolMethod;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Objc1ProtocolMethodList
extends ObjcTypeMetadataStructure {
    public static final String NAME = "objc_protocol_method_list";
    private int method_count;
    private List<Objc1ProtocolMethod> method_list = new ArrayList<Objc1ProtocolMethod>();

    Objc1ProtocolMethodList(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType) throws IOException {
        super(program, state, reader.getPointerIndex());
        if (this.base == 0L) {
            return;
        }
        this.method_count = reader.readNextInt();
        for (int i = 0; i < this.method_count; ++i) {
            this.method_list.add(new Objc1ProtocolMethod(program, state, reader, methodType));
        }
    }

    public int getMethodCount() {
        return this.method_count;
    }

    public List<Objc1ProtocolMethod> getMethodList() {
        return this.method_list;
    }

    public static DataType toGenericDataType(ObjcState state) throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "method_count", null);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_protocol_method_list_" + this.method_count + "_", 0);
        struct.setCategoryPath(Objc1Constants.CATEGORY_PATH);
        struct.add(DWORD, "method_count", null);
        if (this.method_count > 0) {
            DataType dt = this.method_list.get(0).toDataType();
            struct.add((DataType)new ArrayDataType(dt, this.method_count, dt.getLength()), "method_list", null);
        }
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        if (this.base == 0L) {
            return;
        }
        if (this.state.beenApplied.contains(this.base)) {
            return;
        }
        this.state.beenApplied.add(this.base);
        Address address = this.program.getAddressFactory().getDefaultAddressSpace().getAddress(this.base);
        DataType dt = this.toDataType();
        this.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this.program.getListing().createData(address, dt);
        for (Objc1ProtocolMethod method : this.method_list) {
            if (monitor.isCancelled()) break;
            method.applyTo(namespace, monitor);
        }
    }
}

