/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Class;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2MethodList;
import ghidra.app.util.bin.format.objc.objc2.Objc2PropertyList;
import ghidra.app.util.bin.format.objc.objc2.Objc2ProtocolList;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2Category
extends ObjcTypeMetadataStructure {
    public static final String NAME = "category_t";
    private String name;
    private Objc2Class cls;
    private Objc2MethodList instanceMethods;
    private Objc2MethodList classMethods;
    private Objc2ProtocolList protocols;
    private Objc2PropertyList instanceProperties;

    public Objc2Category(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        this.readName(reader);
        this.readClass(reader);
        if (this.cls != null && this.cls.getISA() != null) {
            this.readInstanceMethods(reader);
            this.readClassMethods(reader);
            this.readProtocols(reader);
            this.readInstanceProperties(reader);
        }
    }

    public String getName() {
        return this.name;
    }

    public Objc2Class getCls() {
        return this.cls;
    }

    public Objc2MethodList getInstanceMethods() {
        return this.instanceMethods;
    }

    public Objc2MethodList getClassMethods() {
        return this.classMethods;
    }

    public Objc2ProtocolList getProtocols() {
        return this.protocols;
    }

    public Objc2PropertyList getInstanceProperties() {
        return this.instanceProperties;
    }

    private void readName(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            this.name = reader.readAsciiString(index);
        }
    }

    private void readClass(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (this.state.classIndexMap.containsKey(index)) {
            this.cls = this.state.classIndexMap.get(index);
            return;
        }
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.cls = new Objc2Class(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceMethods(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceMethods = new Objc2MethodList(this.program, this.state, reader, ObjcMethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readClassMethods(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.classMethods = new Objc2MethodList(this.program, this.state, reader, ObjcMethodType.CLASS);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readProtocols(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.protocols = new Objc2ProtocolList(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceProperties(BinaryReader reader) throws IOException {
        long index = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (index != 0L && reader.isValidIndex(index)) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(index);
            this.instanceProperties = new Objc2PropertyList(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NAME);
        if (this.cls == null) {
            buffer.append("<no_class>");
        }
        StructureDataType struct = new StructureDataType(buffer.toString(), 0);
        struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "name", null);
        if (this.cls == null) {
            struct.add((DataType)new PointerDataType(VOID), this.pointerSize, "cls", null);
        } else {
            struct.add((DataType)new PointerDataType(this.cls.toDataType()), this.pointerSize, "cls", null);
        }
        struct.add((DataType)new PointerDataType(Objc2MethodList.toGenericDataType()), this.pointerSize, "instanceMethods", null);
        struct.add((DataType)new PointerDataType(Objc2MethodList.toGenericDataType()), this.pointerSize, "classMethods", null);
        struct.add((DataType)new PointerDataType(Objc2ProtocolList.toGenericDataType(this.is32bit)), this.pointerSize, "protocols", null);
        struct.add((DataType)new PointerDataType(Objc2PropertyList.toGenericDataType()), this.pointerSize, "instanceProperties", null);
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Address address = ObjcUtils.toAddress(this.program, this.base);
        try {
            ObjcUtils.createData(this.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Namespace categoryNamespace = ObjcUtils.createNamespace(this.program, "objc", NAME);
            ObjcUtils.createSymbol(this.program, categoryNamespace, this.getName(), address);
        }
        catch (Exception categoryNamespace) {
            // empty catch block
        }
        Object string = null;
        try {
            string = this.cls.getData().getName() + "_" + this.name + "_";
        }
        catch (Exception e) {
            string = this.name;
        }
        Namespace categoryNamespace = ObjcUtils.createNamespace(this.program, new String[]{"objc", "Categories", string});
        if (this.cls != null) {
            this.cls.applyTo(categoryNamespace, monitor);
        }
        if (this.instanceMethods != null) {
            this.instanceMethods.applyTo(categoryNamespace, monitor);
        }
        if (this.classMethods != null) {
            this.classMethods.applyTo(categoryNamespace, monitor);
        }
        if (this.protocols != null) {
            this.protocols.applyTo(categoryNamespace, monitor);
        }
        if (this.instanceProperties != null) {
            this.instanceProperties.applyTo(categoryNamespace, monitor);
        }
    }
}

