/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2InstanceVariableList;
import ghidra.app.util.bin.format.objc.objc2.Objc2MethodList;
import ghidra.app.util.bin.format.objc.objc2.Objc2PropertyList;
import ghidra.app.util.bin.format.objc.objc2.Objc2ProtocolList;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2ClassRW
extends ObjcTypeMetadataStructure {
    public static final String NAME = "class_rw_t";
    private long flags;
    private long instanceStart;
    private long instanceSize;
    private long reserved;
    private String name;
    private Objc2MethodList baseMethods;
    private Objc2ProtocolList baseProtocols;
    private Objc2InstanceVariableList ivars;
    private long weakIvarLayout;
    private Objc2PropertyList baseProperties;

    public Objc2ClassRW(Program program, ObjcState state) {
        super(program, state, -1L);
    }

    public Objc2ClassRW(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        if (this.is32bit) {
            this.flags = reader.readNextUnsignedInt();
            this.instanceStart = reader.readNextUnsignedInt();
            this.instanceSize = reader.readNextUnsignedInt();
            this.reserved = reader.readNextUnsignedInt();
        } else {
            this.flags = reader.readNextLong();
            this.instanceStart = reader.readNextLong();
            this.instanceSize = reader.readNextLong();
        }
        this.readName(reader);
        this.readBaseMethods(reader);
        this.readBaseProtocols(reader);
        this.readInstanceVariables(reader);
        this.weakIvarLayout = ObjcUtils.readNextIndex(reader, this.is32bit);
        this.readBaseProperties(reader);
    }

    public long getIndex() {
        return this.base;
    }

    public String getName() {
        return this.name;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getInstanceStart() {
        return this.instanceStart;
    }

    public long getInstanceSize() {
        return this.instanceSize;
    }

    public long getReserved() {
        return this.reserved;
    }

    public long getWeakIvarLayout() {
        return this.weakIvarLayout;
    }

    public Objc2MethodList getBaseMethods() {
        return this.baseMethods;
    }

    public Objc2ProtocolList getBaseProtocols() {
        return this.baseProtocols;
    }

    public Objc2InstanceVariableList getInstanceVariables() {
        return this.ivars;
    }

    public Objc2PropertyList getBaseProperties() {
        return this.baseProperties;
    }

    private void readName(BinaryReader reader) throws IOException {
        long nameIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (nameIndex != 0L) {
            this.name = reader.readAsciiString(nameIndex);
        }
    }

    private void readBaseProperties(BinaryReader reader) throws IOException {
        long propertiesIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (propertiesIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(propertiesIndex);
            this.baseProperties = new Objc2PropertyList(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceVariables(BinaryReader reader) throws IOException {
        long instanceVariablesIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (instanceVariablesIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(instanceVariablesIndex);
            this.ivars = new Objc2InstanceVariableList(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readBaseProtocols(BinaryReader reader) throws IOException {
        long protocolsIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (protocolsIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(protocolsIndex);
            this.baseProtocols = new Objc2ProtocolList(this.program, this.state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readBaseMethods(BinaryReader reader) throws IOException {
        long methodsIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        if (methodsIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(methodsIndex);
            this.baseMethods = new Objc2MethodList(this.program, this.state, reader, ObjcMethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        if (this.is32bit) {
            struct.add(DWORD, "flags", null);
            struct.add(DWORD, "instanceStart", null);
            struct.add(DWORD, "instanceSize", null);
            struct.add(DWORD, "reserved", null);
        } else {
            struct.add(QWORD, "flags", null);
            struct.add(QWORD, "instanceStart", null);
            struct.add(QWORD, "instanceSize", null);
        }
        struct.add((DataType)new PointerDataType(ASCII), this.pointerSize, "name", null);
        struct.add((DataType)new PointerDataType(Objc2MethodList.toGenericDataType()), this.pointerSize, "baseMethods", null);
        struct.add((DataType)new PointerDataType(Objc2ProtocolList.toGenericDataType(this.is32bit)), this.pointerSize, "baseProtocols", null);
        struct.add((DataType)new PointerDataType(Objc2InstanceVariableList.toGenericDataType()), this.pointerSize, "ivars", null);
        if (this.is32bit) {
            struct.add(DWORD, "weakIvarLayout", null);
        } else {
            struct.add(QWORD, "weakIvarLayout", null);
        }
        struct.add((DataType)new PointerDataType(Objc2PropertyList.toGenericDataType()), this.pointerSize, "baseProperties", null);
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
        Namespace classNamespace;
        Address address = ObjcUtils.toAddress(this.program, this.getIndex());
        try {
            ObjcUtils.createData(this.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            classNamespace = ObjcUtils.createNamespace(this.program, "objc", NAME);
            ObjcUtils.createSymbol(this.program, classNamespace, this.getName(), address);
        }
        catch (Exception classNamespace2) {
            // empty catch block
        }
        classNamespace = ObjcUtils.getClassNamespace(this.program, null, this.getName());
        if (this.baseMethods != null) {
            this.baseMethods.applyTo(classNamespace, monitor);
        }
        if (this.baseProtocols != null) {
            this.baseProtocols.applyTo(classNamespace, monitor);
        }
        if (this.ivars != null) {
            this.ivars.applyTo(classNamespace, monitor);
        }
        if (this.baseProperties != null) {
            this.baseProperties.applyTo(classNamespace, monitor);
        }
    }
}

