/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.dyld.LibObjcOptimization;
import ghidra.app.util.bin.format.objc.ObjcMethod;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2Implementation;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Objc2Method
extends ObjcMethod {
    private String name;
    private String types;
    private Objc2Implementation imp;
    private LibObjcOptimization libObjcOptimization;
    private boolean isSmall;

    public Objc2Method(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType, boolean isSmallList) throws IOException {
        super(program, state, reader, methodType);
        this.libObjcOptimization = state.libObjcOptimization;
        this.isSmall = isSmallList;
        if (isSmallList) {
            int nameOffset = reader.readNextInt();
            long namePtr = this.is32bit ? (long)reader.readInt(this.base + (long)nameOffset) : (this.libObjcOptimization != null ? (this.libObjcOptimization.getRelativeSelectorBaseAddressOffset() > 0L ? this.libObjcOptimization.getAddr() + this.libObjcOptimization.getRelativeSelectorBaseAddressOffset() + (long)nameOffset : this.base + (long)nameOffset) : reader.readLong(this.base + (long)nameOffset));
            this.name = reader.readAsciiString(namePtr);
            int typesOffset = reader.readNextInt();
            this.types = reader.readAsciiString(this.base + 4L + (long)typesOffset);
        } else {
            long nameIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
            this.name = reader.readAsciiString(nameIndex);
            long typesIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
            this.types = reader.readAsciiString(typesIndex);
        }
        this.imp = new Objc2Implementation(program, state, reader, isSmallList);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypes() {
        return this.types;
    }

    @Override
    public long getImplementation() {
        return this.imp.getImplementation();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("method" + (this.isSmall ? "_small" : "") + "_t", 0);
        if (this.isSmall) {
            String comment = "RelativePointer";
            PointerType REL = PointerType.RELATIVE;
            if (this.libObjcOptimization != null) {
                if (this.libObjcOptimization.getRelativeSelectorBaseAddressOffset() > 0L) {
                    struct.add(DWORD, "name", comment + " + " + Long.toHexString(this.libObjcOptimization.getAddr() + this.libObjcOptimization.getRelativeSelectorBaseAddressOffset()));
                } else {
                    struct.add((DataType)new PointerTypedef(null, (DataType)new PointerDataType(STRING), 4, null, PointerType.RELATIVE), "name", comment);
                }
            } else {
                struct.add((DataType)new PointerTypedef(null, (DataType)new PointerDataType(STRING), 4, null, REL), "name", comment);
            }
            struct.add((DataType)new PointerTypedef(null, STRING, 4, null, REL), "types", comment);
            struct.add((DataType)new PointerTypedef(null, VOID, 4, null, REL), "imp", comment);
        } else {
            struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "name", null);
            struct.add((DataType)new PointerDataType(STRING), this.pointerSize, "types", null);
            struct.add((DataType)new PointerDataType(VOID), this.pointerSize, "imp", null);
        }
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }
}

