/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcMethod;
import ghidra.app.util.bin.format.objc.ObjcMethodList;
import ghidra.app.util.bin.format.objc.ObjcMethodType;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.app.util.bin.format.objc.objc2.Objc2Method;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Objc2MethodList
extends ObjcMethodList {
    public static final String NAME = "method_list_t";
    private int entsizeAndFlags;
    private int count;

    public Objc2MethodList(Program program, ObjcState state, BinaryReader reader, ObjcMethodType methodType) throws IOException {
        super(program, state, reader, NAME);
        if (this.base == 0L) {
            return;
        }
        this.entsizeAndFlags = reader.readNextInt();
        this.count = reader.readNextInt();
        boolean isSmallList = this.isSmallMethods();
        for (int i = 0; i < this.count; ++i) {
            this.methods.add(new Objc2Method(program, state, reader, methodType, isSmallList));
        }
    }

    protected boolean isSmallMethods() {
        return (this.entsizeAndFlags & Integer.MIN_VALUE) != 0;
    }

    public long getEntsizeAndFlags() {
        return this.entsizeAndFlags;
    }

    public long getCount() {
        return this.count;
    }

    public static DataType toGenericDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "entsizeAndFlags", null);
        struct.add(DWORD, "count", null);
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME + (this.isSmallMethods() ? "_small" : "") + "_" + this.count + "_", 0);
        struct.add(DWORD, "entsizeAndFlags", null);
        struct.add(DWORD, "count", null);
        for (int i = 0; i < this.methods.size(); ++i) {
            struct.add(((ObjcMethod)this.methods.get(i)).toDataType(), "method" + i, null);
        }
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }
}

