/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc.ObjcState;
import ghidra.app.util.bin.format.objc.ObjcTypeMetadataStructure;
import ghidra.app.util.bin.format.objc.ObjcUtils;
import ghidra.app.util.bin.format.objc.objc2.Objc2Constants;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class Objc2Property
extends ObjcTypeMetadataStructure {
    private String name;
    private String attributes;

    public Objc2Property(Program program, ObjcState state, BinaryReader reader) throws IOException {
        super(program, state, reader.getPointerIndex());
        long nameIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        this.name = reader.readAsciiString(nameIndex);
        long attributesIndex = ObjcUtils.readNextIndex(reader, this.is32bit);
        this.attributes = reader.readAsciiString(attributesIndex);
    }

    public String getName() {
        return this.name;
    }

    public String getAttributes() {
        return this.attributes;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_property", 0);
        struct.add((DataType)new PointerDataType(ASCII), this.pointerSize, "name", null);
        struct.add((DataType)new PointerDataType(ASCII), this.pointerSize, "name", null);
        struct.setCategoryPath(Objc2Constants.CATEGORY_PATH);
        return struct;
    }

    @Override
    public void applyTo(Namespace namespace, TaskMonitor monitor) throws Exception {
    }
}

