/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftSection;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.PointerTypedefBuilder;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SwiftUtils {
    public static final String SWIFT_COMPILER = "swift";
    public static final TypeDef PTR_RELATIVE = new PointerTypedefBuilder((Pointer)Pointer32DataType.dataType, null).type(PointerType.RELATIVE).build();
    public static final TypeDef PTR_RELATIVE_MASKED = new PointerTypedefBuilder((Pointer)Pointer32DataType.dataType, null).type(PointerType.RELATIVE).bitMask(-2L).build();
    public static final PointerTypedef PTR_STRING = new PointerTypedef(null, (DataType)StringDataType.dataType, 4, null, PointerType.RELATIVE);

    public static boolean isSwift(Program program) {
        List<String> prefixes = List.of("__swift", SWIFT_COMPILER, ".sw5");
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (!prefixes.stream().anyMatch(prefix -> block.getName().startsWith((String)prefix))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSwift(List<String> sectionNames) {
        List<String> prefixes = List.of("__swift", SWIFT_COMPILER, ".sw5");
        for (String sectionName : sectionNames) {
            if (!prefixes.stream().anyMatch(prefix -> sectionName.startsWith((String)prefix))) continue;
            return true;
        }
        return false;
    }

    public static List<MemoryBlock> getSwiftBlocks(SwiftSection section, Program program) {
        ArrayList<MemoryBlock> result = new ArrayList<MemoryBlock>();
        block0: for (MemoryBlock block : program.getMemory().getBlocks()) {
            for (String sectionName : section.getSwiftSectionNames()) {
                if (!block.getName().equals(sectionName)) continue;
                result.add(block);
                continue block0;
            }
        }
        return result;
    }

    public static String relativeString(BinaryReader reader) throws IOException {
        long fieldIndex = reader.getPointerIndex();
        int offset = reader.readNextInt();
        return reader.readAsciiString(fieldIndex + (long)offset);
    }
}

