/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class CaptureTypeRecord
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 4;
    private String mangledTypeName;

    public CaptureTypeRecord(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.mangledTypeName = reader.readNext(SwiftUtils::relativeString);
    }

    public String getMangledTypeName() {
        return this.mangledTypeName;
    }

    @Override
    public String getStructureName() {
        return CaptureTypeRecord.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "capture type record";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_STRING, "MangledTypeName", "");
        return struct;
    }
}

