/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.TypeReferenceKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConformanceFlags
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 4;
    private int flags;

    public ConformanceFlags(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = reader.readNextInt();
    }

    public int getFlags() {
        return this.flags;
    }

    public TypeReferenceKind getKind() {
        return TypeReferenceKind.valueOf(this.flags >> 3 & 3);
    }

    public boolean isRetroactive() {
        return (this.flags >> 6 & 1) != 0;
    }

    public boolean isSynthesizedNonUnique() {
        return (this.flags >> 7 & 1) != 0;
    }

    public int getNumConditionalRequirements() {
        return this.flags >> 8 & 8;
    }

    public boolean hasResilientWitnesses() {
        return (this.flags >> 16 & 1) != 0;
    }

    public boolean hasGenericWitnessTable() {
        return (this.flags >> 17 & 1) != 0;
    }

    public boolean isConformanceOfProtocol() {
        return (this.flags >> 18 & 1) != 0;
    }

    public boolean hasGlobalActorIsolation() {
        return (this.flags >> 19 & 1) != 0;
    }

    public int getNumConditionalPackDescriptor() {
        return this.flags >> 24 & 8;
    }

    @Override
    public String getStructureName() {
        return ConformanceFlags.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "conformance flags";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 4);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(DWORD, 3, "UnusedLowBits", "historical conformance kind");
            struct.addBitField(this.getKind().toDataType(), 3, "TypeMetadataKind", "8 type reference kinds");
            struct.addBitField(BOOL, 1, "IsRetroactive", null);
            struct.addBitField(BOOL, 1, "IsSynthesizedNonUnique", null);
            struct.addBitField(DWORD, 8, "NumConditionalRequirements", null);
            struct.addBitField(BOOL, 1, "HasResilientWitnesses", null);
            struct.addBitField(BOOL, 1, "HasGenericWitnessTable", null);
            struct.addBitField(BOOL, 1, "IsConformanceOfProtocol", null);
            struct.addBitField(BOOL, 1, "HasGlobalActorIsolation", null);
            struct.addBitField(DWORD, 4, "reserved", null);
            struct.addBitField(DWORD, 8, "NumConditionalPackDescriptor", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        return struct;
    }
}

