/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.ContextDescriptorKind;
import ghidra.app.util.bin.format.swift.types.MetadataInitializationKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ContextDescriptorFlags
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 4;
    private int flags;

    public ContextDescriptorFlags(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = reader.readNextInt();
    }

    public int getFlags() {
        return this.flags;
    }

    public ContextDescriptorKind getKind() {
        return ContextDescriptorKind.valueOf(this.flags & 0x1F);
    }

    public boolean hasInvertableProtocols() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isUnique() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isGeneric() {
        return (this.flags & 0x80) != 0;
    }

    public MetadataInitializationKind getMetadataInitialization() {
        return MetadataInitializationKind.valueOf(this.flags >> 16 & 3);
    }

    public boolean hasImportInfo() {
        return (this.flags >> 18 & 1) != 0;
    }

    public boolean hasCanonicalMetadataPrespecializationsOrSingletonMetadataPonter() {
        return (this.flags >> 19 & 1) != 0;
    }

    public boolean hasLayoutString() {
        return (this.flags >> 20 & 1) != 0;
    }

    public boolean hasClassDefaultOverrideTable() {
        return (this.flags >> 22 & 1) != 0;
    }

    public boolean isClassActor() {
        return (this.flags >> 23 & 1) != 0;
    }

    public boolean isClassDefaultActor() {
        return (this.flags >> 24 & 1) != 0;
    }

    public int getClassResilientSuperclassReferenceKind() {
        return this.flags >> 25 & 7;
    }

    public boolean areClassImmediateMembersNegative() {
        return (this.flags >> 28 & 1) != 0;
    }

    public boolean hasClassResilientSuperclass() {
        return (this.flags >> 29 & 1) != 0;
    }

    public boolean hasClassOverrideTable() {
        return (this.flags >> 30 & 1) != 0;
    }

    public boolean hasClassVTable() {
        return (this.flags >> 31 & 1) != 0;
    }

    @Override
    public String getStructureName() {
        return ContextDescriptorFlags.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "context descriptor flags";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 4);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(ContextDescriptorKind.values()[0].toDataType(), 5, "kind", "Kind of context descriptor");
            struct.addBitField(BOOL, 1, "hasInvertableProtocols", "Whether or not the context has information about invertable protocols, which will show up as a trailing field in the context descriptor.");
            struct.addBitField(BOOL, 1, "isUnique", "Whether this is a unique record describing the referenced context.");
            struct.addBitField(BOOL, 1, "isGeneric", "Whether the context being described is generic.");
            struct.addBitField(DWORD, 8, "reserved", null);
            struct.addBitField(MetadataInitializationKind.values()[0].toDataType(), 2, "MetadataInitialization", "Whether there's something unusual about how the metadata is initialized.");
            struct.addBitField(BOOL, 1, "HasImportInfo", "Set if the type has extended import information.");
            struct.addBitField(BOOL, 1, "HasCanonicalMetadataPrespecializationsOrSingletonMetadataPonter", "Set if the generic type descriptor has a pointer to a list of canonical prespecializations, or the non-generic type descriptor has a pointer to its singleton metadata.");
            struct.addBitField(BOOL, 1, "HasLayoutString", "Set if the metadata contains a pointer to a layout string.");
            struct.addBitField(DWORD, 1, "reserved", null);
            struct.addBitField(BOOL, 1, "Class_HasDefaultOverrideTable", null);
            struct.addBitField(BOOL, 1, "Class_IsActor", "Set if the class is an actor.");
            struct.addBitField(BOOL, 1, "Class_IsDefaultActor", "Set if the class is a default actor class.");
            struct.addBitField(DWORD, 3, "Class_ResilientSuperclassReferenceKind", "The kind of reference that this class makes to its resilient superclass descriptor. A TypeReferenceKind.");
            struct.addBitField(BOOL, 1, "Class_AreImmediateMembersNegative", "Whether the immediate class members in this metadata are allocated at negative offsets.");
            struct.addBitField(BOOL, 1, "Class_HasResilientSuperclass", "Set if the context descriptor is for a class with resilient ancestry.");
            struct.addBitField(BOOL, 1, "Class_HasOverrideTable", "Set if the context descriptor includes metadata for dynamically installing method overrides at metadata instantiation time.");
            struct.addBitField(BOOL, 1, "Class_HasVTable", "Set if the context descriptor includes metadata for dynamically constructing a class's vtables at metadata instantiation time.");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        return struct;
    }
}

