/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;

public enum ContextDescriptorKind implements StructConverter
{
    Module(0),
    Extension(1),
    Anonymous(2),
    Protocol(3),
    OpaqueType(4),
    Class(16),
    Struct(17),
    Enum(18);

    private int value;

    private ContextDescriptorKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ContextDescriptorKind valueOf(int value) {
        return Arrays.stream(ContextDescriptorKind.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        EnumDataType dt = new EnumDataType(SwiftTypeMetadataStructure.CATEGORY_PATH, ContextDescriptorKind.class.getSimpleName(), 1);
        for (ContextDescriptorKind kind : ContextDescriptorKind.values()) {
            dt.add(kind.name(), (long)kind.getValue());
        }
        return dt;
    }
}

