/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class GenericContextDescriptorFlags
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 2;
    private short flags;

    public GenericContextDescriptorFlags(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = reader.readNextShort();
    }

    public short getFlags() {
        return this.flags;
    }

    public boolean hasTypePacks() {
        return (this.flags & 1) != 0;
    }

    public boolean hasConditionalInvertedProtocols() {
        return (this.flags & 2) != 0;
    }

    public boolean hasValues() {
        return (this.flags & 4) != 0;
    }

    @Override
    public String getStructureName() {
        return GenericContextDescriptorFlags.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "generic context descriptor flags";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 2);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(BOOL, 1, "TypePacks", "Has at least one type parameter pack and a trailing GenericPackShapeHeader.");
            struct.addBitField(BOOL, 1, "ConditionalInvertedProtocols", "Has any conditional conformances to inverted protocols and a trailing InvertibleProtocolSet and conditional requirements.");
            struct.addBitField(BOOL, 1, "Values", "Has at least one value parameter, and a trailing GenericValueHeader.");
            struct.addBitField(WORD, 13, "reserved", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        return struct;
    }
}

