/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;

public enum GenericRequirementKind implements StructConverter
{
    Protocol(0),
    SameType(1),
    BaseClass(2),
    SameConformance(3),
    SameShape(4),
    IntertedProtocol(5),
    Layout(31);

    private int value;

    private GenericRequirementKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static GenericRequirementKind valueOf(int value) {
        return Arrays.stream(GenericRequirementKind.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        EnumDataType dt = new EnumDataType(SwiftTypeMetadataStructure.CATEGORY_PATH, GenericRequirementKind.class.getSimpleName(), 1);
        for (GenericRequirementKind kind : GenericRequirementKind.values()) {
            dt.add(kind.name(), (long)kind.getValue());
        }
        return dt;
    }
}

