/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.InvertibleProtocolKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class InvertibleProtocolSet
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 2;
    private short bits;

    public InvertibleProtocolSet(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.bits = reader.readNextShort();
    }

    public short getRawBits() {
        return this.bits;
    }

    @Override
    public String getStructureName() {
        return InvertibleProtocolSet.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "invertible protocol set";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(InvertibleProtocolKind.values()[0].toDataType(), "bits", "The storage bits");
        return struct;
    }
}

