/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;

public enum MethodDescriptorKind implements StructConverter
{
    Method(0),
    Init(1),
    Getter(2),
    Setter(3),
    ModifyCoroutine(4),
    ReadCoroutine(5);

    private int value;

    private MethodDescriptorKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MethodDescriptorKind valueOf(int value) {
        return Arrays.stream(MethodDescriptorKind.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        EnumDataType dt = new EnumDataType(SwiftTypeMetadataStructure.CATEGORY_PATH, MethodDescriptorKind.class.getSimpleName(), 1);
        for (MethodDescriptorKind kind : MethodDescriptorKind.values()) {
            dt.add(kind.name(), (long)kind.getValue());
        }
        return dt;
    }
}

