/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.ProtocolRequirementKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ProtocolRequirementFlags
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 4;
    private int flags;

    public ProtocolRequirementFlags(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = reader.readNextInt();
    }

    public int getFlags() {
        return this.flags;
    }

    public ProtocolRequirementKind getKind() {
        return ProtocolRequirementKind.valueOf(this.flags & 0xF);
    }

    public boolean isInstance() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isAnsyc() {
        return (this.flags & 0x20) != 0;
    }

    public int getExtraDescriminator() {
        return this.flags >> 16 & 0xFFFF;
    }

    @Override
    public String getStructureName() {
        return ProtocolRequirementFlags.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "protocol requirements flags";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 4);
        struct.setPackingEnabled(true);
        try {
            struct.addBitField(this.getKind().toDataType(), 4, "kind", null);
            struct.addBitField(BOOL, 1, "IsInstance", null);
            struct.addBitField(BOOL, 1, "IsAsync", null);
            struct.addBitField(DWORD, 10, "reserved", null);
            struct.addBitField(DWORD, 16, "ExtraDescriminator", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        return struct;
    }
}

