/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.ContextDescriptorFlags;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetContextDescriptor
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 8;
    protected ContextDescriptorFlags flags;
    private int parent;

    public TargetContextDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = new ContextDescriptorFlags(reader);
        this.parent = reader.readNextInt();
    }

    public ContextDescriptorFlags getFlags() {
        return this.flags;
    }

    public int getParent() {
        return this.parent;
    }

    @Override
    public String getStructureName() {
        return this.getMyStructureName();
    }

    @Override
    public String getDescription() {
        return "context descriptor";
    }

    private final String getMyStructureName() {
        return TargetContextDescriptor.class.getSimpleName();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getMyStructureName(), 0);
        struct.add(this.flags.toDataType(), "Flags", "Flags describing the context, including its kind and format version");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE_MASKED, "Parent", "The parent context, or null if this is a top-level context");
        return struct;
    }
}

