/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.types.InvertibleProtocolSet;
import ghidra.app.util.bin.format.swift.types.TargetForeignMetadataInitialization;
import ghidra.app.util.bin.format.swift.types.TargetSingletonMetadataInitialization;
import ghidra.app.util.bin.format.swift.types.TargetTypeContextDescriptor;
import ghidra.app.util.bin.format.swift.types.TargetTypeGenericContextDescriptorHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class TargetEnumDescriptor
extends TargetTypeContextDescriptor {
    private int numPayloadCasesAndPayloadSizeOffset;
    private int numEmptyCases;
    private TargetTypeGenericContextDescriptorHeader genericHeader;
    private TargetSingletonMetadataInitialization singleton;
    private TargetForeignMetadataInitialization foreign;
    private InvertibleProtocolSet invertibleProtocolSet;

    public TargetEnumDescriptor(BinaryReader reader) throws IOException {
        super(reader);
        this.numPayloadCasesAndPayloadSizeOffset = reader.readNextInt();
        this.numEmptyCases = reader.readNextInt();
        if (this.flags.isGeneric()) {
            this.genericHeader = new TargetTypeGenericContextDescriptorHeader(reader);
        }
        switch (this.flags.getMetadataInitialization()) {
            case NoMetadataInitialization: {
                break;
            }
            case SingletonMetadataInitialization: {
                this.singleton = new TargetSingletonMetadataInitialization(reader, this.flags);
                break;
            }
            case ForeignMetadataInitialization: {
                this.foreign = new TargetForeignMetadataInitialization(reader);
            }
        }
        if (this.flags.isGeneric() && this.flags.hasCanonicalMetadataPrespecializationsOrSingletonMetadataPonter()) {
            throw new IOException("Unimplemented TargetCanonicalSpecializedMetadatas detected.");
        }
        if (this.flags.hasInvertableProtocols()) {
            this.invertibleProtocolSet = new InvertibleProtocolSet(reader);
        }
        if (!this.flags.isGeneric() && this.flags.hasCanonicalMetadataPrespecializationsOrSingletonMetadataPonter()) {
            throw new IOException("Unimplemented TargetSingletonMetadataPointer detected.");
        }
    }

    public int getNumPayloadCasesAndPayloadSizeOffset() {
        return this.numPayloadCasesAndPayloadSizeOffset;
    }

    public int getNumEmptyCases() {
        return this.numEmptyCases;
    }

    public TargetTypeGenericContextDescriptorHeader getGenericHeader() {
        return this.genericHeader;
    }

    public TargetSingletonMetadataInitialization getTargetSingletonMetadataInitialization() {
        return this.singleton;
    }

    public TargetForeignMetadataInitialization getTargetForeignMetadataInitialization() {
        return this.foreign;
    }

    public InvertibleProtocolSet getInvertibleProtocolSet() {
        return this.invertibleProtocolSet;
    }

    @Override
    public List<SwiftTypeMetadataStructure> getTrailingObjects() {
        ArrayList<SwiftTypeMetadataStructure> ret = new ArrayList<SwiftTypeMetadataStructure>();
        if (this.genericHeader != null) {
            ret.add(this.genericHeader);
            ret.addAll(this.genericHeader.getTrailingObjects());
        }
        if (this.singleton != null) {
            ret.add(this.singleton);
        }
        if (this.foreign != null) {
            ret.add(this.foreign);
        }
        if (this.invertibleProtocolSet != null) {
            ret.add(this.invertibleProtocolSet);
        }
        return ret;
    }

    @Override
    public String getStructureName() {
        return TargetEnumDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "enum descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(super.toDataType(), super.getStructureName(), "");
        struct.add(DWORD, "NumPayloadCasesAndPayloadSizeOffset", "The number of non-empty cases in the enum are in the low 24 bits; the offset of the payload size in the metadata record in words, if any, is stored in the high 8 bits.");
        struct.add(DWORD, "NumEmptyCases", "The number of empty cases in the enum");
        return struct;
    }
}

