/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetForeignMetadataInitialization
extends SwiftTypeMetadataStructure {
    private int completionFunction;

    public TargetForeignMetadataInitialization(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.completionFunction = reader.readNextInt();
    }

    public int getCompletionFunction() {
        return this.completionFunction;
    }

    @Override
    public String getStructureName() {
        return TargetForeignMetadataInitialization.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "foreign metadata initialization";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "CompletionFunction", "The completion function. The pattern will always be null.");
        return struct;
    }
}

