/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.GenericRequirementFlags;
import ghidra.app.util.bin.format.swift.types.GenericRequirementLayoutKind;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetGenericRequirementsDescriptor
extends SwiftTypeMetadataStructure {
    private GenericRequirementFlags flags;
    private int param;
    private int thing;
    private GenericRequirementLayoutKind layout;
    private int genericParamIndex;
    private int protocols;

    public TargetGenericRequirementsDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = new GenericRequirementFlags(reader);
        this.param = reader.readNextInt();
        this.thing = reader.readNextInt();
        this.layout = GenericRequirementLayoutKind.valueOf(this.thing);
        this.genericParamIndex = this.thing & 0xFFFF;
        this.protocols = this.thing & 0xFFFF;
    }

    public GenericRequirementFlags getFlags() {
        return this.flags;
    }

    public int getParam() {
        return this.param;
    }

    public int getThing() {
        return this.thing;
    }

    public GenericRequirementLayoutKind getLayout() {
        return this.layout;
    }

    public int getGenericParamIndex() {
        return this.genericParamIndex;
    }

    public int getProtocols() {
        return this.protocols;
    }

    @Override
    public String getStructureName() {
        return TargetGenericRequirementsDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "generic requirements descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType invertedProtocolsStruct = new StructureDataType(CATEGORY_PATH, "InvertedProtocols", 0);
        invertedProtocolsStruct.add(WORD, "GenericParamIndex", "The index of the generic parameter to which this applies.");
        invertedProtocolsStruct.add(WORD, "Protocols", "The set of invertiable protocols whose check is disabled.");
        UnionDataType union = new UnionDataType(CATEGORY_PATH, "Union_TargetGenericRequirementsDescriptor");
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "Type", "A mangled representation of the same-type or base class the param is constrained to.");
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "Protocol", "The protocol the param is constrained to.");
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "Conformance", "The conformance the param is constrained to use.");
        union.add(GenericRequirementLayoutKind.values()[0].toDataType(), "Layout", "The kind of layout constraint.");
        union.add((DataType)invertedProtocolsStruct, invertedProtocolsStruct.getName(), null);
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(this.flags.toDataType(), "Flags", null);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Param", "The type that's constrained, described as a mangled name.");
        struct.add((DataType)union, union.getName(), null);
        return struct;
    }
}

