/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetGenericWitnessTable
extends SwiftTypeMetadataStructure {
    private int witnessTableSizeInWords;
    private int witnessTablePrivateSizeInWordsAndRequiresInstantiation;
    private int instantiator;
    private int privateData;

    public TargetGenericWitnessTable(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.witnessTableSizeInWords = reader.readNextUnsignedShort();
        this.witnessTablePrivateSizeInWordsAndRequiresInstantiation = reader.readNextUnsignedShort();
        this.instantiator = reader.readNextInt();
        this.privateData = reader.readNextInt();
    }

    public int getWitnessTableSizeInWords() {
        return this.witnessTableSizeInWords;
    }

    public int getWitnessTablePrivateSizeInWordsAndRequiresInstantiation() {
        return this.witnessTablePrivateSizeInWordsAndRequiresInstantiation;
    }

    public int getInstantiator() {
        return this.instantiator;
    }

    public int getPrivateData() {
        return this.privateData;
    }

    @Override
    public String getStructureName() {
        return TargetGenericWitnessTable.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "generic witness table";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(WORD, "WitnessTableSizeInWords", "The size of the witness table in words.");
        struct.add(WORD, "WitnessTablePrivateSizeInWordsAndRequiresInstantiation", "The amount of private storage to allocate before the address point, in words.");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Instantiator", "The instantiation function, which is called after the template is copied.");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "PrivateData", "Private data for the instantiator.");
        return struct;
    }
}

