/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.MethodDescriptorFlags;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetMethodDescriptor
extends SwiftTypeMetadataStructure {
    public static final int SIZE = 8;
    private MethodDescriptorFlags flags;
    private int impl;

    public TargetMethodDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = new MethodDescriptorFlags(reader);
        this.impl = reader.readNextInt();
    }

    public MethodDescriptorFlags getFlags() {
        return this.flags;
    }

    public int getImpl() {
        return this.impl;
    }

    @Override
    public String getStructureName() {
        return TargetMethodDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "method descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(this.flags.toDataType(), "Flags", "Flags describing the method");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Impl", "The method implementation");
        return struct;
    }
}

