/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetOverrideTableHeader
extends SwiftTypeMetadataStructure {
    private long numEntries;

    public TargetOverrideTableHeader(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.numEntries = reader.readNextUnsignedInt();
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    @Override
    public String getStructureName() {
        return TargetOverrideTableHeader.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "override table header";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(DWORD, "NumEntries", "The number of MethodOverrideDescriptor records following the vtable override header in the class's nominal type descriptor.");
        return struct;
    }
}

