/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.ConformanceFlags;
import ghidra.app.util.bin.format.swift.types.TargetGenericWitnessTable;
import ghidra.app.util.bin.format.swift.types.TargetRelativeContextPointer;
import ghidra.app.util.bin.format.swift.types.TargetResilientWitness;
import ghidra.app.util.bin.format.swift.types.TargetResilientWitnessHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class TargetProtocolConformanceDescriptor
extends SwiftTypeMetadataStructure {
    private int protocol;
    private int typeRef;
    private int witnessTablePattern;
    private ConformanceFlags flags;
    private TargetRelativeContextPointer retroactiveContext;
    private TargetResilientWitnessHeader resilientWitnessHeader;
    private List<TargetResilientWitness> resilientWitnesses = new ArrayList<TargetResilientWitness>();
    private TargetGenericWitnessTable genericWitnessTable;

    public TargetProtocolConformanceDescriptor(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.protocol = reader.readNextInt();
        this.typeRef = reader.readNextInt();
        this.witnessTablePattern = reader.readNextInt();
        this.flags = new ConformanceFlags(reader);
        if (this.flags.isRetroactive()) {
            this.retroactiveContext = new TargetRelativeContextPointer(reader);
        }
        if (this.flags.hasResilientWitnesses()) {
            this.resilientWitnessHeader = new TargetResilientWitnessHeader(reader);
            int i = 0;
            while ((long)i < this.resilientWitnessHeader.getNumWitnesses()) {
                this.resilientWitnesses.add(new TargetResilientWitness(reader));
                ++i;
            }
        }
        if (this.flags.hasGenericWitnessTable()) {
            this.genericWitnessTable = new TargetGenericWitnessTable(reader);
        }
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getTypeRef() {
        return this.typeRef;
    }

    public int getWitnessTablePattern() {
        return this.witnessTablePattern;
    }

    public ConformanceFlags getConformanceFlags() {
        return this.flags;
    }

    public TargetRelativeContextPointer getRetroactiveContext() {
        return this.retroactiveContext;
    }

    public TargetResilientWitnessHeader getResilientWitnessHeader() {
        return this.resilientWitnessHeader;
    }

    public List<TargetResilientWitness> getResilientWitnesses() {
        return this.resilientWitnesses;
    }

    public TargetGenericWitnessTable getGenericWitnessTable() {
        return this.genericWitnessTable;
    }

    @Override
    public List<SwiftTypeMetadataStructure> getTrailingObjects() {
        ArrayList<SwiftTypeMetadataStructure> ret = new ArrayList<SwiftTypeMetadataStructure>();
        if (this.retroactiveContext != null) {
            ret.add(this.retroactiveContext);
        }
        if (this.resilientWitnessHeader != null) {
            ret.add(this.resilientWitnessHeader);
            ret.addAll(this.resilientWitnesses);
        }
        if (this.genericWitnessTable != null) {
            ret.add(this.genericWitnessTable);
        }
        return ret;
    }

    @Override
    public String getStructureName() {
        return TargetProtocolConformanceDescriptor.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "protocol conformance descriptor";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE_MASKED, "Protocol", "The protocol being conformed to");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "TypeRef", "Some description of the type that conforms to the protocol");
        struct.add(DWORD, "WitnessTablePattern", "The witness table pattern, which may also serve as the witness table");
        struct.add(this.flags.toDataType(), "Flags", "Various flags, including the kind of conformance");
        return struct;
    }
}

