/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.ProtocolRequirementFlags;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetProtocolRequirement
extends SwiftTypeMetadataStructure {
    private ProtocolRequirementFlags flags;
    private int impl;

    public TargetProtocolRequirement(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.flags = new ProtocolRequirementFlags(reader);
        this.impl = reader.readNextInt();
    }

    public ProtocolRequirementFlags getFlags() {
        return this.flags;
    }

    public int getImpl() {
        return this.impl;
    }

    @Override
    public String getStructureName() {
        return TargetProtocolRequirement.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "protocol requirement";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        UnionDataType union = new UnionDataType(CATEGORY_PATH, "Union_DefaultFuncImplementation_DefaultImplementation");
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "DefaultFuncImplementation", null);
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "DefaultImplementation", null);
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(this.flags.toDataType(), "Flags", null);
        struct.add((DataType)union, "Implementation", "The optional default implementation.");
        return struct;
    }
}

