/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetResilientSuperclass
extends SwiftTypeMetadataStructure {
    private int superclass;

    public TargetResilientSuperclass(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.superclass = reader.readNextInt();
    }

    public int getSuperclass() {
        return this.superclass;
    }

    @Override
    public String getStructureName() {
        return this.getMyStructureName();
    }

    @Override
    public String getDescription() {
        return "resilient superclass";
    }

    private final String getMyStructureName() {
        return TargetResilientSuperclass.class.getSimpleName();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getMyStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "Superclass", "The superclass of this class.");
        return struct;
    }
}

