/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.TargetRelativeProtocolRequirementPointer;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetResilientWitness
extends SwiftTypeMetadataStructure {
    private TargetRelativeProtocolRequirementPointer requirement;
    private int impl;

    public TargetResilientWitness(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.requirement = new TargetRelativeProtocolRequirementPointer(reader);
        this.impl = reader.readNextInt();
    }

    public TargetRelativeProtocolRequirementPointer getRequirement() {
        return this.requirement;
    }

    public int getImpl() {
        return this.impl;
    }

    @Override
    public String getStructureName() {
        return TargetResilientWitness.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "resilient witness";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        UnionDataType union = new UnionDataType(CATEGORY_PATH, "Union_Impl_FuncImpl");
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "Impl", null);
        union.add((DataType)SwiftUtils.PTR_RELATIVE, "FuncImpl", null);
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)TargetRelativeProtocolRequirementPointer.dataType, "Requirement", null);
        struct.add((DataType)union, "Implementation", null);
        return struct;
    }
}

