/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetResilientWitnessHeader
extends SwiftTypeMetadataStructure {
    private long numWitnesses;

    public TargetResilientWitnessHeader(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.numWitnesses = reader.readNextUnsignedInt();
    }

    public long getNumWitnesses() {
        return this.numWitnesses;
    }

    @Override
    public String getStructureName() {
        return TargetResilientWitnessHeader.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "resilient witness header";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(DWORD, "NumWitnesses", null);
        return struct;
    }
}

