/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.app.util.bin.format.swift.types.TargetGenericContextDescriptorHeader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.List;

public class TargetTypeGenericContextDescriptorHeader
extends SwiftTypeMetadataStructure {
    private int instantiationCache;
    private int defaultInstallationPattern;
    private TargetGenericContextDescriptorHeader base;

    public TargetTypeGenericContextDescriptorHeader(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.instantiationCache = reader.readNextInt();
        this.defaultInstallationPattern = reader.readNextInt();
        this.base = new TargetGenericContextDescriptorHeader(reader);
    }

    public int getInstantiationCache() {
        return this.instantiationCache;
    }

    public int getDefaultInstallationPattern() {
        return this.defaultInstallationPattern;
    }

    public TargetGenericContextDescriptorHeader getBaseHeader() {
        return this.base;
    }

    @Override
    public List<SwiftTypeMetadataStructure> getTrailingObjects() {
        return this.base.getTrailingObjects();
    }

    @Override
    public String getStructureName() {
        return TargetTypeGenericContextDescriptorHeader.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "type generic context descriptor header";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "InstantiationCache", "The metadata instantiation cache.");
        struct.add((DataType)SwiftUtils.PTR_RELATIVE, "DefaultInstantiationPattern", "The default instantiation pattern.");
        struct.add(this.base.toDataType(), "Base", "The base header.");
        return struct;
    }
}

