/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TargetVTableDescriptorHeader
extends SwiftTypeMetadataStructure {
    private long vtableOffset;
    private long vtableSize;

    public TargetVTableDescriptorHeader(BinaryReader reader) throws IOException {
        super(reader.getPointerIndex());
        this.vtableOffset = reader.readNextUnsignedInt();
        this.vtableSize = reader.readNextUnsignedInt();
    }

    public long getVTableOffset() {
        return this.vtableOffset;
    }

    public long getVTableSize() {
        return this.vtableSize;
    }

    @Override
    public String getStructureName() {
        return TargetVTableDescriptorHeader.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "vtable descriptor header";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(CATEGORY_PATH, this.getStructureName(), 0);
        struct.add(DWORD, "VTableOffset", "The offset of the vtable for this class in its metadata, if any, in words.");
        struct.add(DWORD, "VTableSize", "The number of vtable entries.");
        return struct;
    }
}

