/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.swift.SwiftTypeMetadataStructure;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;

public enum TypeReferenceKind implements StructConverter
{
    DirectTypeDescriptor(0),
    IndirectTypeDescriptor(1),
    DirectObjCClassName(2),
    IndirectObjCClass(3);

    private int value;

    private TypeReferenceKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TypeReferenceKind valueOf(int value) {
        return Arrays.stream(TypeReferenceKind.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        EnumDataType dt = new EnumDataType(SwiftTypeMetadataStructure.CATEGORY_PATH, TypeReferenceKind.class.getSimpleName(), 1);
        for (TypeReferenceKind kind : TypeReferenceKind.values()) {
            dt.add(kind.name(), (long)kind.getValue());
        }
        return dt;
    }
}

