/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.button.BrowseButton;
import docking.widgets.list.GListCellRenderer;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.NavigationDirection;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.CategoryPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class CategoryPathSelectionEditor
extends AbstractCellEditor {
    private JPanel editorPanel;
    private DropDownSelectionTextField<CategoryPath> selectionField;
    private JButton browseButton;
    private DataTypeManagerService dataTypeManagerService;
    private KeyAdapter keyListener;
    private NavigationDirection navigationDirection;
    private TreePath initiallySelectedTreePath;

    public CategoryPathSelectionEditor(ServiceProvider serviceProvider) {
        this.dataTypeManagerService = (DataTypeManagerService)serviceProvider.getService(DataTypeManagerService.class);
        if (this.dataTypeManagerService == null) {
            throw new NullPointerException("DataTypeManagerService cannot be null");
        }
        this.init();
    }

    public void setConsumeEnterKeyPress(boolean consume) {
        this.selectionField.setConsumeEnterKeyPress(consume);
    }

    protected DropDownSelectionTextField<CategoryPath> createDropDownSelectionTextField(CategoryPathDropDownSelectionDataModel model) {
        return new DropDownSelectionTextField((DropDownTextFieldDataModel)model);
    }

    private void init() {
        this.selectionField = this.createDropDownSelectionTextField(new CategoryPathDropDownSelectionDataModel(this, this.dataTypeManagerService));
        this.selectionField.setName("CategoryPath");
        this.selectionField.getAccessibleContext().setAccessibleName("Category");
        this.selectionField.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                CategoryPathSelectionEditor.this.fireEditingCanceled();
                CategoryPathSelectionEditor.this.navigationDirection = null;
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                CategoryPathSelectionEditor.this.fireEditingStopped();
                CategoryPathSelectionEditor.this.navigationDirection = null;
            }
        });
        this.selectionField.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CategoryPathSelectionEditor.this.selectionField.setEnabled(true);
                CategoryPathSelectionEditor.this.selectionField.requestFocus();
            }
        });
        JPanel browsePanel = this.buildBrowsePanel();
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 0));
        this.editorPanel.add((Component)this.selectionField);
        this.editorPanel.add(browsePanel);
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 9) {
                    CategoryPathSelectionEditor.this.navigationDirection = e.isShiftDown() ? NavigationDirection.BACKWARD : NavigationDirection.FORWARD;
                    CategoryPathSelectionEditor.this.fireEditingStopped();
                    e.consume();
                }
            }
        };
    }

    private JPanel buildBrowsePanel() {
        JPanel browsePanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                int width = this.getBestWidth();
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = Math.min(width, preferredSize.width);
                return preferredSize;
            }

            @Override
            public Dimension getMinimumSize() {
                int width = this.getBestWidth();
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = Math.min(width, preferredSize.width);
                return preferredSize;
            }

            @Override
            public Dimension getMaximumSize() {
                int width = this.getBestWidth();
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = Math.min(width, preferredSize.width);
                return preferredSize;
            }

            private int getBestWidth() {
                Font f = this.getFont();
                FontMetrics fm = this.getFontMetrics(f);
                int width = fm.stringWidth(" . . . ");
                return width;
            }
        };
        browsePanel.setLayout(new BorderLayout());
        browsePanel.setOpaque(false);
        Border empty = BorderFactory.createEmptyBorder(2, 2, 1, 1);
        browsePanel.setBorder(empty);
        this.browseButton = new BrowseButton();
        this.browseButton.setToolTipText("Browse Existing Category Paths");
        this.browseButton.addActionListener(e -> this.showBrowser());
        browsePanel.add(this.browseButton);
        return browsePanel;
    }

    public CategoryPath getCellEditorValue() {
        return (CategoryPath)this.selectionField.getSelectedValue();
    }

    public CategoryPath getCellEditorValueAsCategoryPath() {
        return (CategoryPath)this.selectionField.getSelectedValue();
    }

    public String getCellEditorValueAsText() {
        return this.selectionField.getText();
    }

    public JComponent getEditorComponent() {
        return this.editorPanel;
    }

    public DropDownSelectionTextField<CategoryPath> getDropDownTextField() {
        return this.selectionField;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }

    public void setDefaultSelectedTreePath(TreePath path) {
        this.initiallySelectedTreePath = path;
    }

    public void requestFocus() {
        this.selectionField.requestFocus();
    }

    void selectCellEditorValue() {
        this.selectionField.selectAll();
    }

    public void setCellEditorValueAsText(String text) {
        this.selectionField.setText(text);
        this.navigationDirection = null;
    }

    public void setCellEditorValue(CategoryPath path) {
        this.selectionField.setSelectedValue((Object)path);
        this.navigationDirection = null;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.selectionField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.selectionField.getDocument().removeDocumentListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.selectionField.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.selectionField.removeFocusListener(listener);
    }

    public void setTabCommitsEdit(boolean doesCommit) {
        this.selectionField.setFocusTraversalKeysEnabled(!doesCommit);
        this.removeKeyListener(this.keyListener);
        if (doesCommit) {
            this.addKeyListener(this.keyListener);
        }
    }

    public NavigationDirection getNavigationDirection() {
        return this.navigationDirection;
    }

    private void addKeyListener(KeyListener listener) {
        this.selectionField.addKeyListener(listener);
    }

    private void removeKeyListener(KeyListener listener) {
        this.selectionField.removeKeyListener(listener);
    }

    private void showBrowser() {
        CategoryPath path = this.dataTypeManagerService.getCategoryPath(this.initiallySelectedTreePath);
        if (path != null) {
            this.setCellEditorValue(path);
            this.selectionField.requestFocus();
        }
    }

    public void setEnabled(boolean createStructureByName) {
        this.selectionField.setEnabled(createStructureByName);
    }

    public boolean isEnabled() {
        return this.selectionField.isEnabled();
    }

    private class CategoryPathDropDownSelectionDataModel
    implements DropDownTextFieldDataModel<CategoryPath> {
        private List<CategoryPath> data;

        public CategoryPathDropDownSelectionDataModel(CategoryPathSelectionEditor categoryPathSelectionEditor, DataTypeManagerService dataTypeService) {
            this.data = dataTypeService.getSortedCategoryPathList();
        }

        public ListCellRenderer<CategoryPath> getListRenderer() {
            return new CategoryPathDropDownRenderer();
        }

        public String getDescription(CategoryPath categoryPath) {
            return null;
        }

        public String getDisplayText(CategoryPath categoryPath) {
            return categoryPath.getPath();
        }

        public List<DropDownTextFieldDataModel.SearchMode> getSupportedSearchModes() {
            return List.of(DropDownTextFieldDataModel.SearchMode.CONTAINS, DropDownTextFieldDataModel.SearchMode.STARTS_WITH, DropDownTextFieldDataModel.SearchMode.WILDCARD);
        }

        public List<CategoryPath> getMatchingData(String searchText) {
            throw new UnsupportedOperationException("Method no longer supported.  Instead, call getMatchingData(String, SearchMode)");
        }

        public List<CategoryPath> getMatchingData(String searchText, DropDownTextFieldDataModel.SearchMode mode) {
            boolean startsWith;
            if (StringUtils.isBlank((CharSequence)searchText)) {
                return new ArrayList<CategoryPath>(this.data);
            }
            if (!this.getSupportedSearchModes().contains(mode)) {
                throw new IllegalArgumentException("Unsupported SearchMode: " + String.valueOf(mode));
            }
            Pattern p = mode.createPattern(searchText);
            boolean bl = startsWith = mode == DropDownTextFieldDataModel.SearchMode.STARTS_WITH;
            if (startsWith) {
                String pattern = p.pattern();
                String newPattern = "/{0,1}" + pattern;
                p = Pattern.compile(newPattern, 2);
            }
            return this.getMatchingDataRegex(p, startsWith);
        }

        private List<CategoryPath> getMatchingDataRegex(Pattern p, boolean startsWith) {
            ArrayList<CategoryPath> results = new ArrayList<CategoryPath>();
            for (CategoryPath path : this.data) {
                Object text = startsWith ? "/" + path.getName() : path.getPath();
                Matcher m = p.matcher((CharSequence)text);
                if (!m.matches()) continue;
                results.add(path);
            }
            return results;
        }

        public int getIndexOfFirstMatchingEntry(List<CategoryPath> dataCollection, String text) {
            int lastPreferredMatchIndex = -1;
            int i = 0;
            while (i < this.data.size()) {
                CategoryPath dataType = this.data.get(i);
                String dataTypeName = dataType.getName();
                if ((dataTypeName = dataTypeName.replaceAll(" ", "")).equals(text)) {
                    return i;
                }
                if (!dataTypeName.equalsIgnoreCase(text)) {
                    return lastPreferredMatchIndex;
                }
                lastPreferredMatchIndex = i++;
            }
            return -1;
        }

        private class CategoryPathDropDownRenderer
        extends GListCellRenderer<CategoryPath> {
            private CategoryPathDropDownRenderer() {
            }

            protected String getItemText(CategoryPath path) {
                return path.getPath();
            }

            public Component getListCellRendererComponent(JList<? extends CategoryPath> list, CategoryPath value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
                return this;
            }
        }
    }
}

