/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.importer;

import docking.widgets.button.BrowseButton;
import docking.widgets.textfield.ElidingFilePathTextField;
import ghidra.app.util.Option;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.options.SaveState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DomainFolderOption
extends Option {
    public DomainFolderOption(String name, String arg, boolean hidden) {
        super(name, String.class, "", arg, null, "LOADER_OPTIONS", hidden);
    }

    @Override
    public Component getCustomEditorComponent() {
        SaveState state = this.getState();
        String defaultValue = (String)this.getValue();
        String lastFolderPath = state != null ? state.getString(this.getName(), defaultValue) : defaultValue;
        this.setValue(lastFolderPath);
        ElidingFilePathTextField textField = new ElidingFilePathTextField(lastFolderPath);
        textField.setEditable(false);
        textField.setColumns(10);
        BrowseButton button = new BrowseButton();
        button.addActionListener(arg_0 -> this.lambda$getCustomEditorComponent$0(lastFolderPath, (JTextField)textField, state, arg_0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)textField, "Center");
        panel.add((Component)button, "East");
        return panel;
    }

    @Override
    public Class<?> getValueClass() {
        return String.class;
    }

    @Override
    public Option copy() {
        return new DomainFolderOption(this.getName(), this.getArg(), this.isHidden());
    }

    private /* synthetic */ void lambda$getCustomEditorComponent$0(String lastFolderPath, JTextField textField, SaveState state, ActionEvent e) {
        DataTreeDialog dataTreeDialog = new DataTreeDialog(null, "Choose a project folder", DataTreeDialogType.CHOOSE_FOLDER);
        String folderPath = lastFolderPath.isBlank() ? "/" : lastFolderPath;
        dataTreeDialog.setSelectedFolder(AppInfo.getActiveProject().getProjectData().getFolder(folderPath));
        dataTreeDialog.showComponent();
        DomainFolder folder = dataTreeDialog.getDomainFolder();
        if (folder != null) {
            String newFolderPath = folder.getPathname();
            textField.setText(newFolderPath);
            this.setValue(newFolderPath);
            if (state != null) {
                state.putString(this.getName(), newFolderPath);
            }
        }
    }
}

