/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.prelink.MachoPrelinkMap;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.BidiMap;

public class MachoPrelinkProgramBuilder
extends MachoProgramBuilder {
    private List<Address> chainedFixups = new ArrayList<Address>();

    protected MachoPrelinkProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) throws Exception {
        super(program, provider, fileBytes, log, monitor);
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) throws Exception {
        MachoPrelinkProgramBuilder machoPrelinkProgramBuilder = new MachoPrelinkProgramBuilder(program, provider, fileBytes, log, monitor);
        machoPrelinkProgramBuilder.build();
    }

    @Override
    protected void build() throws Exception {
        super.build();
        List<MachoInfo> machoInfoList = this.processPrelinkFileSet();
        if (machoInfoList.isEmpty()) {
            machoInfoList = this.processPrelinkXml();
        }
        this.monitor.initialize((long)machoInfoList.size());
        for (MachoInfo info : machoInfoList) {
            info.processMemoryBlocks();
            info.markupHeaders();
            info.markupLoadCommandData();
            info.addToProgramTree();
            this.monitor.incrementProgress(1L);
        }
        ProgramModule rootModule = this.listing.getDefaultRootModule();
        for (Group group : rootModule.getChildren()) {
            ProgramFragment fragment;
            if (!(group instanceof ProgramFragment) || !(fragment = (ProgramFragment)group).isEmpty()) continue;
            rootModule.removeChild(fragment.getName());
        }
        super.markupChainedFixups(this.machoHeader, this.chainedFixups);
    }

    private List<MachoInfo> processPrelinkFileSet() throws Exception {
        ArrayList<MachoInfo> machoInfoList = new ArrayList<MachoInfo>();
        for (FileSetEntryCommand cmd : this.machoHeader.getLoadCommands(FileSetEntryCommand.class)) {
            MachoInfo info = new MachoInfo(this.provider, cmd.getFileOffset(), this.space.getAddress(cmd.getVMaddress()), cmd.getFileSetEntryId().getString());
            machoInfoList.add(info);
        }
        return machoInfoList;
    }

    private List<MachoInfo> processPrelinkXml() throws Exception {
        ArrayList<MachoInfo> machoInfoList = new ArrayList<MachoInfo>();
        List<Long> machoHeaderOffsets = MachoPrelinkUtils.findPrelinkMachoHeaderOffsets(this.provider, this.monitor);
        if (machoHeaderOffsets.isEmpty()) {
            return machoInfoList;
        }
        List<MachoPrelinkMap> prelinkList = MachoPrelinkUtils.parsePrelinkXml(this.provider, this.monitor);
        BidiMap<MachoPrelinkMap, Long> map = MachoPrelinkUtils.matchPrelinkToMachoHeaderOffsets(this.provider, prelinkList, machoHeaderOffsets, this.monitor);
        long prelinkStart = MachoPrelinkUtils.getPrelinkStartAddr(this.machoHeader);
        Address prelinkStartAddr = null;
        prelinkStartAddr = prelinkStart == 0L ? this.program.getImageBase().add(machoHeaderOffsets.get(0).longValue()) : this.space.getAddress(prelinkStart);
        for (Long machoHeaderOffset : machoHeaderOffsets) {
            String path;
            String name = "";
            MachoPrelinkMap prelink = (MachoPrelinkMap)map.getKey((Object)machoHeaderOffset);
            if (prelink != null && (path = prelink.getPrelinkBundlePath()) != null) {
                name = new File(path).getName();
            }
            machoInfoList.add(new MachoInfo(this.provider, machoHeaderOffset, prelinkStartAddr.add(machoHeaderOffset - machoHeaderOffsets.get(0)), name));
        }
        return machoInfoList;
    }

    @Override
    protected void renameObjMsgSendRtpSymbol() throws DuplicateNameException, InvalidInputException {
    }

    @Override
    protected void markupChainedFixups(MachHeader header, List<Address> fixups) throws CancelledException {
        this.chainedFixups = fixups;
    }

    private class MachoInfo {
        private Address headerAddr;
        private MachHeader header;
        private String name;

        public MachoInfo(ByteProvider provider, long offset, Address headerAddr, String name) throws Exception {
            this.headerAddr = headerAddr;
            this.header = new MachHeader(provider, offset, false);
            this.header.parse();
            this.headerAddr = headerAddr;
            this.name = name;
        }

        public void processMemoryBlocks() throws Exception {
            MachoPrelinkProgramBuilder.this.processMemoryBlocks(this.header, this.name, true, false);
        }

        public void markupHeaders() throws Exception {
            MachoPrelinkProgramBuilder.this.markupHeaders(this.header, this.headerAddr);
            if (!this.name.isEmpty()) {
                MachoPrelinkProgramBuilder.this.listing.setComment(this.headerAddr, CommentType.PLATE, this.name);
            }
        }

        public void markupLoadCommandData() throws Exception {
            MachoPrelinkProgramBuilder.this.markupLoadCommandData(this.header, this.name);
        }

        public void addToProgramTree() throws Exception {
            ProgramModule module;
            if (this.name.isEmpty()) {
                return;
            }
            try {
                module = MachoPrelinkProgramBuilder.this.listing.getDefaultRootModule().createModule(this.name);
            }
            catch (DuplicateNameException e) {
                MachoPrelinkProgramBuilder.this.log.appendMsg("Failed to add duplicate module to program tree: " + this.name);
                return;
            }
            for (SegmentCommand segment : this.header.getAllSegments()) {
                if (segment.getVMsize() == 0L || segment.getSegmentName().equals("__LINKEDIT")) continue;
                Address segmentStart = MachoPrelinkProgramBuilder.this.space.getAddress(segment.getVMaddress());
                Address segmentEnd = segmentStart.add(segment.getVMsize() - 1L);
                if (!MachoPrelinkProgramBuilder.this.memory.contains(segmentEnd)) {
                    segmentEnd = MachoPrelinkProgramBuilder.this.memory.getBlock(segmentStart).getEnd();
                }
                ProgramFragment segmentFragment = module.createFragment(String.format("%s - %s", segment.getSegmentName(), this.name));
                segmentFragment.move(segmentStart, segmentEnd);
                for (Section section : segment.getSections()) {
                    if (section.getSize() == 0L) continue;
                    Address sectionStart = MachoPrelinkProgramBuilder.this.space.getAddress(section.getAddress());
                    Address sectionEnd = sectionStart.add(section.getSize() - 1L);
                    if (!MachoPrelinkProgramBuilder.this.memory.contains(sectionEnd)) {
                        sectionEnd = MachoPrelinkProgramBuilder.this.memory.getBlock(sectionStart).getEnd();
                    }
                    ProgramFragment sectionFragment = module.createFragment(String.format("%s %s - %s", section.getSegmentName(), section.getSectionName(), this.name));
                    sectionFragment.move(sectionStart, sectionEnd);
                }
                if (!segmentFragment.isEmpty()) continue;
                module.removeChild(segmentFragment.getName());
            }
        }
    }
}

