/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.util.viewer.field.AddressFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.listingpanel.EmptyListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModelListener;
import ghidra.app.util.viewer.util.AddressBasedIndexMapper;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.ImmutableAddressSet;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Dimension;
import java.math.BigInteger;

public class ListingModelAdapter
implements LayoutModel,
ListingModelListener {
    private static Class<?> defaultFieldFactoryClass = AddressFieldFactory.class;
    private final ListingModel model;
    private WeakSet<LayoutModelListener> listeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private AddressIndexMap addressToIndexMap;
    private SwingUpdateManager updateMgr;
    private Dimension preferredViewSize;

    public ListingModelAdapter(ListingModel bigListingModel) {
        this.model = bigListingModel != null ? bigListingModel : new EmptyListingModel();
        this.addressToIndexMap = new AddressIndexMap(this.model.getAddressSet());
        this.removeUnviewableAddressRanges();
        this.model.addListener(this);
        this.updateMgr = new SwingUpdateManager(500, 5000, () -> {
            if (!this.model.isClosed()) {
                this.resetIndexMap();
                for (LayoutModelListener listener : this.listeners) {
                    listener.dataChanged(BigInteger.ZERO, this.addressToIndexMap.getIndexCount());
                }
                this.preferredViewSize = null;
            }
        });
    }

    public void flushChanges() {
        if (this.updateMgr.hasPendingUpdates()) {
            this.updateMgr.updateNow();
        }
    }

    public void addLayoutModelListener(LayoutModelListener listener) {
        this.listeners.add((Object)listener);
    }

    public BigInteger getIndexAfter(BigInteger index) {
        Address address = this.addressToIndexMap.getAddress(index);
        if (address == null) {
            return null;
        }
        Address nextAddress = this.model.getAddressAfter(address);
        if (nextAddress == null) {
            return null;
        }
        BigInteger nextIndex = this.addressToIndexMap.getIndexAtOrAfter(nextAddress);
        if (nextIndex == null) {
            nextIndex = index.add(BigInteger.ONE);
        }
        return nextIndex;
    }

    public BigInteger getIndexBefore(BigInteger index) {
        if (index.compareTo(BigInteger.ZERO) <= 0) {
            return null;
        }
        BigInteger indexCount = this.addressToIndexMap.getIndexCount();
        if (index.compareTo(indexCount) >= 0) {
            return indexCount.subtract(BigInteger.ONE);
        }
        Address address = this.addressToIndexMap.getAddress(index);
        if (address == null) {
            return null;
        }
        Address previousAddress = this.model.getAddressBefore(address);
        if (previousAddress == null) {
            return null;
        }
        BigInteger previousIndex = this.addressToIndexMap.getIndex(previousAddress);
        if (previousIndex == null) {
            if (index.equals(BigInteger.ZERO)) {
                return null;
            }
            previousIndex = index.subtract(BigInteger.ONE);
        }
        return previousIndex;
    }

    public Layout getLayout(BigInteger index) {
        Address address = this.addressToIndexMap.getAddress(index);
        if (address == null) {
            return null;
        }
        return this.model.getLayout(address, this.addressToIndexMap.isGapIndex(index));
    }

    public Dimension getPreferredViewSize() {
        if (this.preferredViewSize == null) {
            this.preferredViewSize = this.computePreferredViewSize();
        }
        return this.preferredViewSize;
    }

    private Dimension computePreferredViewSize() {
        BigInteger indexCount = this.getNumIndexes();
        int preferredHeight = indexCount.compareTo(BigInteger.valueOf(100L)) > 0 ? 500 : this.computePreferredHeight(indexCount.intValue());
        return new Dimension(this.model.getMaxWidth(), preferredHeight);
    }

    private int computePreferredHeight(int n) {
        int height = 0;
        for (int i = 0; i < n; ++i) {
            Layout layout = this.getLayout(BigInteger.valueOf(i));
            if (layout == null) continue;
            height += layout.getHeight();
        }
        return height;
    }

    public BigInteger getNumIndexes() {
        return this.addressToIndexMap.getIndexCount();
    }

    public boolean isUniform() {
        return false;
    }

    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void dispose() {
        this.updateMgr.dispose();
        this.model.dispose();
    }

    @Override
    public void dataChanged(boolean updateImmediately) {
        if (updateImmediately) {
            this.updateMgr.updateNow();
        } else {
            this.updateMgr.update();
        }
    }

    @Override
    public void modelSizeChanged() {
        this.preferredViewSize = null;
        for (LayoutModelListener listener : this.listeners) {
            listener.modelSizeChanged(IndexMapper.IDENTITY_MAPPER);
        }
    }

    public FieldLocation getFieldLocation(ProgramLocation location) {
        FieldLocation floc = this.getFieldLocation(location.getByteAddress(), location, false);
        if (floc != null) {
            return floc;
        }
        floc = this.getFieldLocation(location.getAddress(), location, false);
        if (floc != null) {
            return floc;
        }
        return this.getFieldLocation(location.getAddress(), location, true);
    }

    private FieldLocation getFieldLocation(Address address, ProgramLocation location, boolean useDefaultLocation) {
        BigInteger index = this.addressToIndexMap.getIndex(address);
        Layout layout = this.getLayout(index);
        if (layout == null) {
            index = this.getLayoutWithinCodeUnit(address);
            layout = this.getLayout(index);
        }
        if (layout == null) {
            return null;
        }
        if (layout.getNumFields() == 0) {
            return null;
        }
        int defaultFieldIndex = 0;
        for (int i = 0; i < layout.getNumFields(); ++i) {
            FieldLocation floc;
            Field f = layout.getField(i);
            if (!(f instanceof ListingField)) continue;
            ListingField field = (ListingField)f;
            FieldFactory factory = field.getFieldFactory();
            if (factory.getClass() == defaultFieldFactoryClass) {
                defaultFieldIndex = i;
            }
            if ((floc = factory.getFieldLocation(field, index, i, location)) == null) continue;
            return floc;
        }
        if (useDefaultLocation) {
            return new FieldLocation(index, defaultFieldIndex, 0, 0);
        }
        return null;
    }

    private BigInteger getLayoutWithinCodeUnit(Address address) {
        CodeUnit cu = this.model.getProgram().getListing().getCodeUnitContaining(address);
        if (cu == null) {
            return null;
        }
        Address min = cu.getMinAddress();
        while (address.compareTo((Object)min) > 0) {
            Layout layout = this.model.getLayout(address = address.subtract(1L), false);
            if (layout == null) continue;
            return this.addressToIndexMap.getIndex(address);
        }
        return null;
    }

    public ProgramLocation getProgramLocation(FieldLocation floc) {
        ProgramLocation programLocation;
        if (floc == null) {
            return null;
        }
        BigInteger index = floc.getIndex();
        Layout layout = this.getLayout(index);
        if (layout == null) {
            Address addr = this.addressToIndexMap.getAddress(index);
            return addr != null ? new ProgramLocation(this.model.getProgram(), addr) : null;
        }
        Field f = floc.getFieldNum() >= layout.getNumFields() ? layout.getField(0) : layout.getField(floc.getFieldNum());
        if (f instanceof ListingField) {
            ListingField bf = (ListingField)f;
            programLocation = this.getProgramLocation(floc, bf);
        } else {
            programLocation = null;
        }
        return programLocation;
    }

    public ProgramLocation getProgramLocation(FieldLocation location, Field field) {
        if (field instanceof ListingField) {
            ListingField lf = (ListingField)field;
            FieldFactory factory = lf.getFieldFactory();
            ProgramLocation pLoc = factory.getProgramLocation(location.getRow(), location.getCol(), lf);
            if (pLoc == null) {
                Address addr = this.addressToIndexMap.getAddress(location.getIndex());
                Program p = this.model.getProgram();
                if (addr != null && p != null) {
                    pLoc = new ProgramLocation(p, addr);
                }
            }
            return pLoc;
        }
        return null;
    }

    public ProgramSelection getAllProgramSelection() {
        return new ProgramSelection(this.model.getAddressSet());
    }

    public ProgramSelection getProgramSelection(FieldSelection selection) {
        ProgramSelection ps;
        AddressSet addrSet = this.addressToIndexMap.getAddressSet(selection);
        if (addrSet.getNumAddressRanges() == 1 && (ps = this.getInteriorSelection(selection)) != null) {
            return ps;
        }
        addrSet = this.model.adjustAddressSetToCodeUnitBoundaries(addrSet);
        return new ProgramSelection((AddressSetView)addrSet);
    }

    private ProgramSelection getInteriorSelection(FieldSelection sel) {
        Data subData1;
        Address max1;
        Data data2;
        Program program = this.model.getProgram();
        if (program == null || sel.getNumRanges() != 1) {
            return null;
        }
        FieldRange range = sel.getFieldRange(0);
        ProgramLocation loc1 = this.getProgramLocation(new FieldLocation(range.getStart().getIndex(), range.getStart().getFieldNum(), 0, 0));
        BigInteger endIndex = range.getEnd().getIndex();
        int endField = range.getEnd().getFieldNum();
        if (endField == 0) {
            Layout layout = this.getLayout(endIndex = endIndex.subtract(BigInteger.ONE));
            if (layout != null) {
                endField = layout.getNumFields() - 1;
            }
        } else {
            --endField;
        }
        ProgramLocation loc2 = this.getProgramLocation(new FieldLocation(endIndex, endField, 0, 0));
        if (loc1 == null || loc2 == null) {
            return null;
        }
        int[] path1 = loc1.getComponentPath();
        int[] path2 = loc2.getComponentPath();
        if (path1 == null || path2 == null) {
            return null;
        }
        if (path1.length > path2.length) {
            return null;
        }
        if (path1.length == 0) {
            return null;
        }
        for (int i = 0; i < path1.length - 1; ++i) {
            if (path1[i] == path2[i]) continue;
            return null;
        }
        Address min = loc1.getAddress();
        Data data1 = program.getListing().getDataContaining(loc1.getAddress());
        if (!data1.equals((Object)(data2 = program.getListing().getDataContaining(loc2.getAddress())))) {
            return null;
        }
        Data subData2 = data2.getComponent(path2);
        Data parent = subData2.getParent();
        DataType dt = parent.getBaseDataType();
        if (dt instanceof Array) {
            return this.selectHighestLevelArray(parent);
        }
        Address max2 = subData2.getMaxAddress();
        if (path1.length != path2.length && !(max1 = (subData1 = data2.getComponent(path1)).getMaxAddress()).equals((Object)max2)) {
            return null;
        }
        InteriorSelection is = new InteriorSelection(loc1, loc2, min, max2);
        return new ProgramSelection(is);
    }

    private ProgramSelection selectHighestLevelArray(Data arrayData) {
        Data highestArrayData = this.findHighestArrayData(arrayData);
        Address min = highestArrayData.getMinAddress();
        Address max = highestArrayData.getMaxAddress();
        Program program = highestArrayData.getProgram();
        int[] componentPath = highestArrayData.getComponentPath();
        if (componentPath.length == 0) {
            return null;
        }
        ProgramLocation loc1 = new ProgramLocation(program, min, componentPath, null, 0, 0, 0);
        ProgramLocation loc2 = new ProgramLocation(program, max, componentPath, null, 0, 0, 0);
        return new ProgramSelection(new InteriorSelection(loc1, loc2, min, max));
    }

    private Data findHighestArrayData(Data arrayData) {
        Data highest = arrayData;
        for (Data parent = arrayData.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent.getBaseDataType() instanceof Array)) continue;
            highest = parent;
        }
        return highest;
    }

    protected void resetIndexMap() {
        AddressIndexMap previous = this.addressToIndexMap.reset();
        this.removeUnviewableAddressRanges();
        AddressBasedIndexMapper mapper = new AddressBasedIndexMapper(previous, this.addressToIndexMap);
        for (LayoutModelListener listener : this.listeners) {
            listener.modelSizeChanged((IndexMapper)mapper);
        }
    }

    private boolean removeUnviewableAddressRanges() {
        boolean changed = false;
        AddressSet set = this.findUnviewableAddressRanges();
        while (!set.isEmpty()) {
            changed = true;
            this.addressToIndexMap.removeUnviewableAddressRanges(set);
            set = this.findUnviewableAddressRanges();
        }
        return changed;
    }

    private AddressSet findUnviewableAddressRanges() {
        BigInteger stepSize = this.addressToIndexMap.getMiniumUnviewableGapSize();
        BigInteger indexCount = this.addressToIndexMap.getIndexCount();
        AddressSet addressSet = new AddressSet();
        BigInteger index = BigInteger.ZERO;
        while (index.compareTo(indexCount) < 0) {
            this.checkIndex(index, addressSet);
            index = index.add(stepSize);
        }
        return addressSet;
    }

    private void checkIndex(BigInteger index, AddressSet addressSet) {
        BigInteger indexBefore;
        BigInteger indexAfter = this.getIndexAfter(index);
        if (indexAfter == null) {
            indexAfter = this.addressToIndexMap.getIndexCount();
        }
        if ((indexBefore = this.getIndexBefore(index.add(BigInteger.ONE))) == null) {
            indexBefore = BigInteger.ZERO;
        }
        if (indexAfter.subtract(indexBefore).compareTo(this.addressToIndexMap.getMiniumUnviewableGapSize()) > 0) {
            Address start = this.addressToIndexMap.getAddress(indexBefore.add(BigInteger.ONE));
            Address end = this.addressToIndexMap.getAddress(indexAfter.subtract(BigInteger.ONE));
            if (start != null && end != null && start.getAddressSpace().equals((Object)end.getAddressSpace())) {
                addressSet.add(start, end);
            }
        }
    }

    public Layout getLayout(Address addr) {
        BigInteger index = this.addressToIndexMap.getIndex(addr);
        return this.getLayout(index);
    }

    public AddressIndexMap getAddressIndexMap() {
        return this.addressToIndexMap;
    }

    public FieldSelection getFieldSelection(ProgramSelection selection) {
        return this.addressToIndexMap.getFieldSelection(selection);
    }

    public void setAddressSet(AddressSetView view) {
        view = ImmutableAddressSet.asImmutable((AddressSetView)view);
        this.addressToIndexMap = new AddressIndexMap(view);
        this.removeUnviewableAddressRanges();
        this.modelSizeChanged();
    }

    public void viewUpdated() {
        this.removeUnviewableAddressRanges();
        this.modelSizeChanged();
    }
}

