/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.services.FieldMouseHandlerService;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.field.FieldMouseHandler;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.util.ProgramLocation;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldNavigator
implements ButtonPressedListener,
FieldMouseHandlerService {
    private Map<Class<?>, List<FieldMouseHandler>> fieldMouseHandlers;
    private ServiceProvider serviceProvider;
    private final Navigatable navigatable;

    public FieldNavigator(ServiceProvider serviceProvider, Navigatable navigatable) {
        GoToService service;
        this.serviceProvider = serviceProvider;
        if (navigatable == null && (service = (GoToService)serviceProvider.getService(GoToService.class)) != null) {
            navigatable = service.getDefaultNavigatable();
        }
        this.navigatable = navigatable;
    }

    private void fieldElementClicked(Object clickedObject, ProgramLocation programLocation, MouseEvent mouseEvent) {
        List<FieldMouseHandler> handlerList = this.getFieldMouseHandlersForLocation(clickedObject.getClass());
        if (this.processHandlerList(handlerList, clickedObject, programLocation, mouseEvent)) {
            return;
        }
        handlerList = this.getFieldMouseHandlersForLocation(programLocation.getClass());
        this.processHandlerList(handlerList, clickedObject, programLocation, mouseEvent);
    }

    private boolean processHandlerList(List<FieldMouseHandler> handlerList, Object clickedObject, ProgramLocation programLocation, MouseEvent mouseEvent) {
        if (handlerList != null) {
            for (FieldMouseHandler element : handlerList) {
                FieldMouseHandler handler = element;
                if (!handler.fieldElementClicked(clickedObject, this.navigatable, programLocation, mouseEvent, this.serviceProvider)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<Class<?>, List<FieldMouseHandler>> initializeFieldMouseHandlers() {
        HashMap map = new HashMap();
        List instances = ClassSearcher.getInstances(FieldMouseHandler.class);
        for (FieldMouseHandler fieldMouseHandler : instances) {
            this.addHandler(map, fieldMouseHandler);
        }
        return map;
    }

    private void addHandler(Map<Class<?>, List<FieldMouseHandler>> map, FieldMouseHandler fieldMouseHandler) {
        Class<?>[] supportedLocations;
        for (Class<?> element2 : supportedLocations = fieldMouseHandler.getSupportedProgramLocations()) {
            List<FieldMouseHandler> list = map.get(element2);
            if (list == null) {
                list = new ArrayList<FieldMouseHandler>();
            }
            list.add(fieldMouseHandler);
            map.put(element2, list);
        }
    }

    private Map<Class<?>, List<FieldMouseHandler>> getFieldMouseHandlers() {
        if (this.fieldMouseHandlers == null) {
            this.fieldMouseHandlers = this.initializeFieldMouseHandlers();
        }
        return this.fieldMouseHandlers;
    }

    private List<FieldMouseHandler> getFieldMouseHandlersForLocation(Class<?> programLocationClass) {
        return this.getFieldMouseHandlers().get(programLocationClass);
    }

    @Override
    public void buttonPressed(ProgramLocation location, FieldLocation fieldLocation, ListingField field, MouseEvent event) {
        Object clickedFieldElement = field.getClickedObject(fieldLocation);
        this.fieldElementClicked(clickedFieldElement, location, event);
    }

    @Override
    public void addFieldMouseHandler(FieldMouseHandler handler) {
        this.addHandler(this.getFieldMouseHandlers(), handler);
    }
}

